<copyright> Behaviour common to all classes and state instances.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995-1998 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: All.t,v 1.59 1998/07/08 13:22:14 tiggr Exp $</id>
    </copyright>

// The TOM files use the double-slash comments extensively.  Unqualified
// comments indicate problems with the TOM source proper, with the
// runtime, or interface to C (i.e. misfeature, bug, or something like
// that).  When qualified by `CCC' it indicates a problem with tomc (the
// TOM compiler); when qualified by `GGG' it indicates a problem GNU CC
// has with the output generated.  In both cases, the comment will
// indicate what was supposed to be there originally (but was temporarily
// changed to get a working tom unit).

<doc> The {All} class does not serve a purpose.  It is the stateless {All}
    instance which is inherited by both the {State} class and instance,
    and, supposedly, by all objects not inheriting from {State}.  </doc>
implementation class All end;

implementation instance
All: Conditions, Constants
{
  <doc><h4>Paramount constants.</h4></doc>
  <doc> The boolean truth.  </doc>
  const TRUE = !0;
  <doc> The boolean non-truth.  </doc>
  const FALSE = !TRUE;
  <doc> An alternative name for {TRUE}.  </doc>
  const YES = TRUE;
  <doc> An alternative name for {FALSE}.  </doc>
  const NO = FALSE;
}

<doc> Return a string informally describing this object.

    This returns the result of having the receiver {write} itself into a
    new {String} which is subsequently returned.  </doc>
String
  description
{
  MutableByteString s = [MutableByteString withCapacity 16];
  [self write s];
  = s;
}

<doc> The selector equivalent of `==', i.e. the returned {result} is
    {TRUE} iff the receiving object and the {other} object are the same
    object.

    The postcondition states that this method is not overridable.  </doc>
boolean (result)
  eq All other
post
  (self == other) == result
{
  = self == other;
}

<doc> Return {TRUE} when the receiving object considers itself equal to
    the other object.  For instance, two {Number} objects holding the same
    value will return {TRUE}.

    The receiving object should be able to assume the {other} object is of
    the same kind, or at least shares with it a common superclass, as in
    the case of, for instance, {CharString} and {ByteString} which are
    both subclasses of {String} and can compare with each other.

    As stated by the postcondition, an object must be {equal} to itself.
    This knowledge may be used by a caller to prevent a method invocation.
    </doc>
boolean (result)
  equal id other
post
  self == other -> result
{
  = self == other;
}

<doc> Return a hash value for the receiving object.  The default
    implementation returns some bit pattern deduced from {self}.

    Two distinct objects considering themselves {equal} should also return
    the same {hash} value.  </doc>
extern int
  hash;

<doc> Hash the address of the receiving object.  For classes not
    redefining {hash}, this performs the same function.  </doc>
extern int
  hashq;

<doc> Return the receiving object.  </doc>
id (self)
  self
{
}

<doc> All objects, even classes, know how to (descriptively) write
    themselves to a stream.

    A default implementation of this method is provided by the {State}
    class and instance.  </doc>
deferred OutputStream
  write OutputStream s;

/******************** behaviour / inheritance ********************/

<doc><h4>Inheritance issues</h4></doc>

<doc> Return {TRUE} iff the receiving object is a class object.  An
    implementation for this method is provided by the {State} class and
    instance.  </doc>
deferred boolean
  classp;

<doc> Return {TRUE} iff the class of the receiving object is a subclass of
    the {class}.  </doc>
extern boolean
  isKindOf class (State) a_class;

<doc> Return the class of the receiving object.  </doc>
deferred class (id)
  kind;

<doc> Return {YES} iff the selector {sel} can be safely sent to the
    receiver.  The default implementation only checks whether the
    receiving object provides a direct implementation of the {sel}; any
    checking through an alternative {forwardDelegate} should be performed
    by the object itself.  </doc>
extern boolean
  respondsTo selector sel;

/******************** forward / perform ********************/

<doc><h4>Forwarding and performing</h4></doc>

<doc> Return an object of which the method indicated by the selector {sel}
    should be invoked.  This method is invoked if the receiving object
    does not directly respond to {sel}.  The default implementation
    returns {self}.  The object returned could be a delegate which is to
    act upon behalf of the receiving object for the intended call of the
    selector {sel}.  </doc>
All (self)
  forwardDelegate selector sel
{
}

<doc> Return the result of forwarding the {invocation}, for example by
    firing it at an appropriate object.  The default implementation
    raises a {program-condition} {SelectorCondition}.  </doc>
InvocationResult
  forwardInvocation Invocation invocation
{
  [[SelectorCondition for self class program-condition
		      message "unrecognized selector"
		      selector [invocation selector]] raise];
}

<doc> Send the receiving object a message with the selector {sel} and the,
    possibly unboxed, {arguments}.  The number of elements of {arguments}
    must match the number of arguments dictated by the selector.

    Unboxing the arguments means that if an {int} argument is needed, the
    {int at int} method will be used to retrieve the argument from the
    {arguments}, possibly resulting in the object retrieved being asked
    for its {intValue}.  </doc>
extern dynamic
  perform selector sel
	: Array arguments = nil;

<doc> Send the receiving object a message with the selector {sel} and the
    {arguments}.  The number of {arguments} must match the number of
    arguments dictated by the selector.

    If the selector {sel} accepts more than one argument, {arguments}
    should be a tuple.  The tuple-ization of the actual arguments to the
    selector {sel} and the elements of the {arguments} tuple is ignored.
    </doc>
extern dynamic
  perform selector sel
     with dynamic arguments;

<doc> Like {perform with} but create a new thread for the performance.
    Return the newly created thread or {nil} upon failure.  </doc>
extern Thread
  performInThread selector sel
	     with dynamic arguments;

<doc> Return {YES} iff the receiving object is an {Invocation}.  Only
    {Invocation} objects are supposed to return {YES}.  </doc>
boolean
  invocationp
{
}

/******************** variable manipulation ********************/

<doc><h4>Object manipulation</h4></doc>

// These semantics are wrong; some condition could be signaled, or
// something else like that.  In any way, an (optional?) argument should
// be necessary to indicate the class where the variable originated.  The
// same remark applies to {setValue ofvariableNamed}.
// Tue May 14 23:20:13 1996, tiggr@tricky.es.ele.tue.nl
<doc> Retrieve the value of the variable with the indicated {name}.  If
    there is more than one variable with the same name and expected return
    type, the first is returned.  </doc>
extern dynamic
  valueOfVariableNamed ByteString name;

<doc> Set the value of the variable named {name} in the receiving object
    to the {value}.  It is an error if the type of the value does
    not exactly match the actual type of the variable: no conversion is
    performed.  </doc>
extern void
	 setValue dynamic value
  ofVariableNamed ByteString name;

<doc> Return the type of the variable named {name} as introduced by the
    extension {ext}.  This returns one of the {TYPEDESC_*} {Constants}.
    </doc>
int
  typeOfVariableNamed String name
		 from Extension ext
pre
  [[self stateExtensions] memq ext] != nil
{
  = [ext typeOfVariableNamed name in self];
}

<doc> Return the boxed value of the variable named {name} as introduced by
    the extension {ext}.  </doc>
Any
  valueOfVariableNamed String name
		  from Extension ext
pre
  [[self stateExtensions] memq ext] != nil
{
  = [ext valueOfVariableNamed name in self];
}

/******************** extensions ********************/

<doc> Return the {Extension} object of this object for the extension named
    {name}.  If {name == nil}, the main extension is returned.  </doc>
extern Extension
  extensionNamed String name
      inherited: boolean check_supers = NO;

<doc> Return an array of state introducing extensions of the receiving
    object.  This includes the extensions introduced by superclasses.
    </doc>
extern Indexed
  stateExtensions;

/******************** catch / throw ********************/

<doc><h4>Conditions and condition handling</h4></doc>

<doc> Throw execution to the catch specified for the receiving object,
    returning the {value}.  If the {value} is {void}, the default value
    for the type to be returned by the catch is returned.  </doc>
extern void
  throw dynamic value;

/******************** conditions ********************/

<doc> This method is invoked for a failed precondition of a method
    invocation of the receiving object.  The method is identified by the
    {selector} {sel}.  The default implementation raises a
    {condition-condition} {SelectorCondition}.

    Method precondition checking is enabled is the option {:cc-pre} is
    provided on the program's command line.  The code for precondition
    checking is normally compiled in by the compiler.  This code is
    omitted by passing the {-fno-checks} or {-fno-pre-checks} option to
    the compiler.  </doc>
void
  preconditionFailed selector sel
{
  [[SelectorCondition for self class condition-condition
		      message "precondition not met" selector sel] raise];
}

<doc> This method is invoked for a failed postcondition of a method
    invocation of the receiving object.  The method is identified by the
    {selector} {sel}.  The default implementation raises a
    {condition-condition} {SelectorCondition}.

    Similar to precondition checking, postcondition checking is enabled by
    the {:cc-post} option on the command line of this program and not
    providing {-fno-checks} or {-fno-post-checks} to the compiler.  </doc>
void
  postconditionFailed selector sel
{
  [[SelectorCondition for self class condition-condition
		      message "postcondition not met" selector sel] raise];
}

/******************** (un-) implementation ********************/

// These methods are `protected', but that is not really the desired
// semantics: The actual protection is supposed to be that, in the actual
// invocation, the only valid receiver is {self}.
// Sun May 19 17:22:49 1996, tiggr@tricky.es.ele.tue.nl
<doc> Moan about the selector {sel} not yet having been implemented by the
    receiving object.  This raises an {unimplemented} {SelectorCondition}.
    </doc>
protected void
  unimplemented selector sel
       message: String message = nil
{
  // The default is nil, and it is substituted in that case by a default
  // message.  This is to remind me of the fact that it is impossible to
  // refer to the defaults from C.
  // Tue May 21 14:18:17 1996, tiggr@tom.es.ele.tue.nl
  [[SelectorCondition for self class unimplemented
		      message !message ? "not yet implemented" : message
		      selector sel] raise];
}

<doc> Contrairy to what the inheritance tells you about the {selector}
    {sel} being invokable for the receiving object, that object thinks
    otherwise.  </doc>
protected void
  shouldNotImplement selector sel
{
  [[SelectorCondition for self class unimplemented
		      message "should not implement" selector sel] raise];
}

<doc> Moan about the receiving object defining a method for the selector
    {sel}, but actually the implementation of the method by the object
    thinks it should be implemented by a subclass.  </doc>
protected void
  subclassResponsibility selector sel
{
  [[SelectorCondition for self class unimplemented
		      message "subclass responsibility" selector sel] raise];
}

/******************** Cons ********************/
<doc><h4><a name="cons">Cons methods</a></h4></doc>

<doc> Return {TRUE} iff the receiving object is a {Cons} cell.  The
    default implementation returns {NO}.  </doc>
boolean
  consp
{
}

<doc> Finish outputing the list, of which the receiving object is the
    tail, to the stream {s}.  The default implementation writes itself
    as a dotted cdr at the end of the list.  </doc>
OutputStream
  writeListElement OutputStream s
{
  = [s print (" . ", self, ")")];
}

/******************** coding ********************/
<doc><h4><a name="coding">Coding methods</a></h4></doc>

<doc> Return {YES} iff the receiving object is a persistent object.  This
    is significant for distributed objects, where class objects and
    {Selector} instances must be persistent across different invocations.
    </doc>
deferred boolean
  persistent-coding-p;

/******************** miscellaneous ********************/

<doc><h4><a name="misc">Miscellaneous</a></h4></doc>

<doc> Return the address of the receiving object as a pointer.  This is
    here solely to be able to print the address of objects, for debugging
    purposes.  </doc>
extern pointer
  address;

<doc> Return {YES} if the receiving object should be maintained in the
    permanent object store when coding.  This does not matter for
    archiving; it makes a difference for DO.  Class objects and
    {Selector}s return {TRUE} for this; the default implementation returns
    {FALSE}.  </doc>
boolean
  coding-permanent-object-p
{
}

<doc> Dump the graph of which the receiving object is the root to stderr.
    </doc>
void
   dump (boolean, boolean) (allow_self, allow_simple)
  level int level
{
  OutputStream s = [stdio err];
  MutableEqSet set = [MutableEqSet new];
  MutableByteString indent = [MutableByteString new];

  if (allow_self && [self dump_self_p])
    [self dumpSelf set indent indent simple allow_simple level level to s];
  else
    [self dump set indent indent simple allow_simple level level to s];

  [s nl];
}

<doc> Like {void dump (boolean, boolean)}, allowing self/simple printing
    and doing infinite recursion.  </doc>
void
  dump
{
  [self dump (YES, YES) level 0];
}

<doc> Return {TRUE} iff the receiving object can be dumped simply.  This
    will be true for class objects, strings, numbers, etc.  This method is
    overridden by {dump_self_p}.  The default implementation returns
    {FALSE}.  </doc>
boolean
  dump_simple_p
{
}

<doc> Return {TRUE} iff the receiving object wants to dump itself instead
    of having its variables scrutinized.  This is used by collection
    objects and others which employ {pointer} typed variables.  The
    default implementation returns {FALSE}.  </doc>
boolean
  dump_self_p
{
}

<doc> Dump the receiving object to the stream {s}, simply.  This is only
    ever invoked if the object returns {YES} for {dump_simple_p}.  The
    default implementation simply prints {self} to the stream.  </doc>
OutputStream
  dump_simple OutputStream s
{
  = [s print self];
}

<doc> Have the receiving object dump itself.  Only ever invoked if it
    returns {TRUE} for {dump_self_p}.  The default implementation invokes
    {shouldNotImplement}.  </doc>
protected void
  dumpSelf MutableKeyed done
    indent MutableByteString prefix
    simple boolean allow_simple
     level int level
	to OutputStream s
{
  [self shouldNotImplement cmd];
}

<doc> Hard worker for {dump}.  </doc>
deferred protected void
    dump MutableKeyed done
  indent MutableByteString prefix
  simple boolean allow_simple
   level int level
      to OutputStream s;

<doc> Return {YES} iff the receiving object has not yet been marked alive
    during the current run of the garbage collector.  Class objects are
    never dead.  </doc>
extern boolean
  gc_dead_p;

<doc> Mark the receiving object as being alive.  This method is only
    needed by the container garbage collection scheme.

    This method is invoked during Garbage Collection.  During GC, the
    {Runtime} library is running in panic mode.  If anything goed wrong,
    for instance a condition is signaled or raised, the program will
    abort.  Moral: be careful during garbage collection.  </doc>
extern void
  gc_mark;

end;
