/* Interface to TLSymbolValue class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLSymbolValue.h,v 1.1 1998/01/08 16:13:41 tiggr Exp $  */

#import "TLSymbol.h"

@interface TLSymbolValue: TLObject
{
  /* The symbol.  */
  TLSymbol *sym;

  /* It's previous value.  */
  id val;

  /* Iff !0, the symbol wasn't previously bound.  */
  unsigned int unbound;
}

/* Return a new symbol value for the unbound SYMBOL.  */
+(TLSymbolValue *) symbolValueWithSymbol: (TLSymbol *) symbol;

/* Return a new symbol value for the SYMBOL previously bound to VALUE.  */
+(TLSymbolValue *) symbolValueWithSymbol: (TLSymbol *) symbol value: value;

-initWithSymbol: (TLSymbol *) symbol;
-initWithSymbol: (TLSymbol *) symbol value: value;

-(void) restoreSymbolValue;

@end
