/* 
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLNumber.h,v 1.1 1998/01/08 16:13:29 tiggr Exp $  */

#import "TLObject.h"

@protocol TLNumber

/* Return the encoding (as through @encode) of the type represented.  */
-(char) encoding;

-(double) doubleValue;
-(float) floatValue;

-(double) floatPDoubleValue;
-(float) floatPFloatValue;

-(char) charValue;
-(short) shortValue;
-(int) intValue;
-(long) longValue;
-(long long) longLongValue;

-(unsigned char) unsignedCharValue;
-(unsigned short) unsignedShortValue;
-(unsigned int) unsignedIntValue;
-(unsigned long) unsignedLongValue;
-(unsigned long long) unsignedLongLongValue;

-(char) integerPCharValue;
-(short) integerPShortValue;
-(int) integerPIntValue;
-(long) integerPLongValue;
-(long long) integerPLongLongValue;

-(unsigned char) integerPUnsignedCharValue;
-(unsigned short) integerPUnsignedShortValue;
-(unsigned int) integerPUnsignedIntValue;
-(unsigned long) integerPUnsignedLongValue;
-(unsigned long long) integerPUnsignedLongLongValue;

-(id <TLNumber>) numberByAdd: (id <TLNumber>) v;
-(id <TLNumber>) numberBySubtract: (id <TLNumber>) v;
-(id <TLNumber>) numberByMultiply: (id <TLNumber>) v;
-(id <TLNumber>) numberByDivide: (id <TLNumber>) v;
-(id <TLNumber>) numberByModulo: (id <TLNumber>) v;
-(id <TLNumber>) numberByAnd: (id <TLNumber>) v;
-(id <TLNumber>) numberByOr: (id <TLNumber>) v;
-(id <TLNumber>) numberByXor: (id <TLNumber>) v;

-(id <TLNumber>) numberByAddingInt: (int) v;
-(id <TLNumber>) numberBySubtractingInt: (int) v;
-(id <TLNumber>) numberByMultiplyingByInt: (int) v;
-(id <TLNumber>) numberByDividingByInt: (int) v;
-(id <TLNumber>) numberByModuloByInt: (int) v;
-(id <TLNumber>) numberByAndWithInt: (int) v;
-(id <TLNumber>) numberByOrWithInt: (int) v;
-(id <TLNumber>) numberByXorWithInt: (int) v;

-(id) lessThan: (id <TLNumber>) v;
-(id) lessThanOrEqual: (id <TLNumber>) v;
-(id) notEqual: (id <TLNumber>) v;
-(id) equal: (id <TLNumber>) v;
-(id) greaterThanOrEqual: (id <TLNumber>) v;
-(id) greaterThan: (id <TLNumber>) v;

@end

@interface TLNumber: TLObject <TLNumber>
{
  union
  {
    char c;
    short s;
    int i;
    long l;
    long long q;
    float f;
    double d;
  } v;

  char encoding;
}

+(TLNumber *) numberWithDouble: (double) v;
+(TLNumber *) numberWithFloat: (float) v;

+(TLNumber *) numberWithChar: (char) v;
+(TLNumber *) numberWithShort: (short) v;
+(TLNumber *) numberWithInt: (int) v;
+(TLNumber *) numberWithLong: (long) v;
+(TLNumber *) numberWithLongLong: (long long) v;

+(TLNumber *) numberWithUnsignedChar: (unsigned char) v;
+(TLNumber *) numberWithUnsignedShort: (unsigned short) v;
+(TLNumber *) numberWithUnsignedInt: (unsigned int) v;
+(TLNumber *) numberWithUnsignedLong: (unsigned long) v;
+(TLNumber *) numberWithUnsignedLongLong: (unsigned long long) v;

#ifdef TLNUMBER_DECLARE_PRIVATE_METHODS

-initWithDouble: (double) v;
-initWithFloat: (float) v;

-initWithChar: (char) v;
-initWithShort: (short) v;
-initWithInt: (int) v;
-initWithLong: (long) v;
-initWithLongLong: (long long) v;

-initWithUnsignedChar: (unsigned char) v;
-initWithUnsignedShort: (unsigned short) v;
-initWithUnsignedInt: (unsigned int) v;
-initWithUnsignedLong: (unsigned long) v;
-initWithUnsignedLongLong: (unsigned long long) v;

#endif

@end
