/* Interface to TLBufferedStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLBufferedStream.h,v 1.1 1998/01/08 16:13:09 tiggr Exp $  */

#ifdef TLBUFFEREDSTREAM_DECLARE_PRIVATE_METHODS
#define TLSTREAMSTREAM_DECLARE_PRIVATE_METHODS
#endif

#import "TLStreamStream.h"
#import "TLMutableString.h"

@interface TLBufferedStream: TLStreamStream <TLStream, TLInputOutputStream,
					     TLBufferedInputStream>
{
  /* The buffer.  */
  char *buf;

  /* CAP is the maximum number of bytes the buffer can hold.  NUM is the
     number of bytes it actually holds.  NEXT is the index of the next
     character to be read.  */
  int next, num, cap;

  /* Iff !0, the buffer contains unwritten data.  */
  unsigned int buf_write_p: 1;

  /* Iff !0, there was an EOF.  */
  unsigned int eof: 1;
}

/******************** line-based reading ********************/

/* Read a line returning a TLString or TLMutableString, respectively.
   Trailing new-line is dropped.  */
-(TLString *) readLine;
-(TLMutableString *) readMutableLine;

#ifdef TLBUFFEREDSTREAM_DECLARE_PRIVATE_METHODS

/* Read N bytes into the buffer B.  Only invoked when the input buffer BUF
   is empty, and thus the offset correspondence needs to be adjusted.  */
-(int) copyBytes: (int) n intoBuffer: (char *) b;

/* Write N bytes from the buffer B.  Only invoked when the output buffer BUF
   is empty, and thus the offset correspondence needs to be adjusted.  */
-(int) copyBytes: (int) n fromBuffer: (const char *) b;

/* Notice that all characters in the buffer have been read c.q. written.
   This advances the notion of the offset at the start of the buffer and
   resets NUM and NEXT.  */
-(void) emptyBuffer;

/* Read an extra N bytes into the buffer, at position OFF within the buffer.
   This does not affect the offset within the STREAM of the start of the
   buffer.  */
-(int) readBytes: (int) n toOffset: (int) off;

/* Hard worker for `-readLine' and `-readMutableLine'.  */
-(id <TLString>) readLineIntoInstanceOf: (id <TLStringCreationUsage>) class;

#endif

@end
