/* Implementation of TLSymbolValue class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLSymbolValue.m,v 1.2 1998/02/23 14:17:42 tiggr Exp $  */

#import "tl/support.h"
#import "tl/TLSymbolValue.h"
#import "tl/TLSymbol.h"

@implementation TLSymbolValue

+(TLSymbolValue *) symbolValueWithSymbol: (TLSymbol *) symbol
{
  return ([[self gcAlloc] initWithSymbol: symbol]);
} /* symbolValueWithSymbol: */

+(TLSymbolValue *) symbolValueWithSymbol: (TLSymbol *) symbol value: value
{
  return ([[self gcAlloc] initWithSymbol: symbol value: value]);
} /* symbolValueWithSymbol:value: */

-initWithSymbol: (TLSymbol *) symbol
{
  sym = symbol;
  unbound = 1;
  return (self);
} /* -initWithSymbol: */

-initWithSymbol: (TLSymbol *) symbol value: value
{
  sym = symbol;
  val = value;
  return (self);
} /* -initWithSymbol:value: */

-(void) restoreSymbolValue
{
  if (unbound)
    [sym makunbound];
  else
    [sym setVarValue: val];
} /* -restoreSymbolValue */

/******************** garbage collection ********************/

-(void) gcReference
{
  MARK (sym);
  if (!unbound)
    MARK (val);
} /* -gcReference */

@end
