/* Implementation of TLLInvocation: TLL Objective-C messaging.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLInvocation.m,v 1.2 1998/02/23 14:17:30 tiggr Exp $  */

#import "tl/support.h"
#import "tl/TLLInvocation.h"
#import "tl/TLCons.h"
#import "tl/TLLSubroutine.h"

@implementation TLLInvocation

+(TLLInvocation *) invocationWithCompressedList: (TLCons *) list
 length: (int) len
{
  return ([[self gcAlloc] initWithCompressedList: list length: len]);
} /* +invocationWithCompressedList:length: */

+(TLLInvocation *) invocationWithList: (TLCons *) list length: (int) len
{
  return ([[self gcAlloc] initWithList: list length: len]);
} /* +invocationWithList: */

-(void) dealloc
{
  xfree (args);
} /* -dealloc */

-eval
{
  id *a;

  if (!num_args)
    a = 0;
  else
    {
      a = alloca (num_args * sizeof (*a));
      memcpy (a, args, num_args * sizeof (*a));
    }
  return (tll_invoke_method (receiver, selector, a, num_args, YES));
} /* -eval */

-(void) gcReference
{
  MARK (selector);
  MARK (receiver);
  if (num_args)
    {
      int i;

      for (i = 0; i < num_args; i++)
	MARK (args[i]);
    }
} /* -gcReference */

-(id) initWithCompressedList: (TLCons *) list length: (int) len
{
  DECONS (list, receiver, list);
  ASGN_IVAR (receiver, receiver);
  DECONS (list, selector, list);
  ASGN_IVAR (selector, selector);

  if (len < 2)
    {
      /* This is an error, but we won't report it.  */
    }
  else if (len > 2)
    {
      int i;

      num_args = len - 2;
      args = xmalloc (num_args * sizeof (*args));
      for (i = 0; i < num_args; i++)
	{
	  DECONS (list, args[i], list);
	  ASGN_IVAR (args[i], args[i]);
	}
    }
  return (self);
} /* -initWithCompressedList:length: */

-(id) initWithList: (TLCons *) list length: (int) len
{
  int i, args_left, method_name_len, method_element_name_len;
  TLString *method_element_name;
  TLSymbol *method_element;

  /* XXX Static buffer to build the method name.  */
  static int method_name_cap;
  static char *method_name;

  DECONS (list, receiver, list);
  ASGN_IVAR (receiver, receiver);
  DECONS (list, method_element, list);

  args_left = num_args = (len - 1) / 2;
  args = xmalloc (num_args * sizeof (*args));
  method_name_len = i = 0;
  do
    {
      method_element_name = [method_element symbolName];
      method_element_name_len = [method_element_name length];
      if (method_name_len + method_element_name_len >= method_name_cap)
	{
	  method_name_cap = method_name_len + method_element_name_len + 1;
	  method_name = xrealloc (method_name, method_name_cap);
	}
      memcpy (method_name + method_name_len,
	      [method_element_name cString], method_element_name_len);
      method_name_len += method_element_name_len;

      if (!args_left)
	break;

      args_left--;
      DECONS (list, args[i], list);
      ASGN_IVAR (args[i], args[i]);
      i++;
      DECONS (list, method_element, list);
    } while (args_left);

  ASGN_IVAR (selector, [CO_TLSymbol symbolWithName:
			[CO_TLString stringWithCString:
			 method_name length: method_name_len]]);

  return (self);
} /* -initWithList: */

-(void) print: (id <TLOutputStream>) stream quoted: (BOOL) qp
{
  int i;

  [stream writeBytes: 2 fromBuffer: "(@"];
  print (receiver, stream, qp);
  [stream writeByte: ' '];
  print (selector, stream, qp);

  for (i = 0; i < num_args; i++)
    {
      [stream writeByte: ' '];
      print (args[i], stream, qp);
    }

  [stream writeByte: ')'];
} /* -print:quoted: */

@end
