/* This is a TOM test.
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: test3.t,v 1.6 1998/01/05 01:01:10 tiggr Exp $  */

<doc> Test the {ByteSubstring} class.  </doc>
implementation class Test: State, Conditions, stdio

void
  result String s
      of boolean b
{
  String q = b ? " passed" : " failed";
  [[out print (s, q)] nl];
}

int
  main Array arguments
{
  ByteString b = "Hello, world";
  ByteString subb = "ello, worl";
  int i, len = [b length];
  String sub = [b substring (1, len - 2)];
  byte c;

  [[out print b] nl];
  [[out print sub] nl];
  for (i = 0; i < len - 2; i++)
    {
      c = sub[i];
      [out print c];
    }
  [out nl];

  UniqueString u = [UniqueString with sub];

  [self result "uniquing" of u == [UniqueString with subb]];
  [self result "sub equal unique" of [sub equal u]];
  [self result "unique equal sub" of [u equal sub]];

  = 0;
}

end;

implementation instance Test end;
