/* LTT unit handling.  -*- objc -*-
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: unit.m,v 1.14 1998/01/05 00:58:32 tiggr Exp $  */

#import "ltt.h"

/* The current acceptor, i.e. the object fed what we find.  */
id <LTTUnitAcceptor> current_acceptor;

/* Units loaded during this load_unit invocation.  */
static TLCons *this_units_loaded;

LTTUnit *
ltt_find_unit (id <TLString> name)
{
  LTTUnit *r;

  r = [CO_LTTUnit findUnitNamed: name];
  
  while (this_units_loaded)
    {
      LTTUnit *u;

      DECONS (this_units_loaded, name, this_units_loaded);

      u = [CO_LTTUnit unitNamed: name];
      [u resolvePosing];
    }

  return r;
} /* ltt_find_unit */

int
load_unit (id <TLString> name, TLVector *path, id <TLString> gendir,
	   id <LTTUnitAcceptor> acceptor, TLString **filename)
{
  id unit_file_name = formac (nil, @"%@." TOM_UNIT_SUFFIX, name);
  id <TLString> real_name;
  int r = -1;
  FILE *f;

  real_name = locate_file_along_path (unit_file_name, path, name, gendir);

  /* We always try to open, to get the proper `No such file or directory'
     (XXX And implicitly have `.' in our searchpath).  */
  real_name = real_name ? real_name : unit_file_name;
  *filename = real_name;
  f = fopen ([real_name cString], "r");

  if (!f)
    error (@"%@: %s", real_name, ERRMSG);
  else
    {
      r = read_unit (f, real_name, acceptor);

      if (fclose (f))
	warning (@"%@: close: %s", real_name, ERRMSG);

      this_units_loaded = CONS (name, this_units_loaded);
    }

  return r;
} /* load_unit */

int
read_unit (FILE *file, id <TLString> name, id <LTTUnitAcceptor> acceptor)
{
  id previous_acceptor = current_acceptor;
  int r;
  GCDECL2;

  PARSE_START_CONTEXT (name);

  GCPRO2 (current_filename, current_acceptor);
  current_acceptor = acceptor;

  ltt_parse_unit (file);

  r = this_num_errors;

  PARSE_STOP_CONTEXT;

  current_acceptor = previous_acceptor;

  PARSE_END_CONTEXT;

  GCUNPRO;

  return r ? -1 : 0;
} /* read_unit */
