/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTStringCST.m,v 1.6 1998/06/26 15:29:36 tiggr Exp $  */

#define LTTSTRINGCST_DECLARE_PRIVATE_METHODS
#import "LTTStringCST.h"
#import "ltt.h"

@implementation LTTStringCST

+(LTTStringCST *) stringWithString: (id <TLString>) str
			      name: (id <TLString>) n
{
  LTTStringCST *s = [[self gcAlloc] initWithString: str name: n];

  [s setSemantics: [self semanticsForString: s]];

  return s;
}

-(void) gcReference
{
  MARK (string);

  [super gcReference];
}

-(id) initWithString: (TLString *) str
		name: (id <TLString>) n;
{
  if (![super initWithName: [LTTName nameWithInternal: n]])
    return nil;

  string = str;

  return self;
}

-(id <TLString>) outputDefinitionName
{
  return formac (nil, @"%@%@", TO_STRING_DST_PREFIX, quote ([name external]));
}

-(id <TLString>) outputReferenceName
{
  return formac (nil, @"%@%@", TO_STRING_CST_PREFIX, quote ([name external]));
}

-(id <TLString>) string
{
  return string;
}

@end
