/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 199-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTName.m,v 1.6 1998/01/05 00:58:11 tiggr Exp $  */

#import "LTTName.h"
#import "ltt.h"

@implementation LTTName

+(LTTName *) nameWithInternal: (id <TLString>) i
{
  return [self nameWithInternal: i external: quote (i)];
}

+(LTTName *) nameWithInternal: (id <TLString>) i external: (id <TLString>) e
{
  return [[self gcAlloc] initWithInternal: i external: e];
}

-(int) compare: (id) o
{
  abort ();
}

-equal: (id) o
{
  abort ();
}

-(void) gcReference
{
  MARK (internal);
  MARK (external);

  [super gcReference];
}

-(unsigned int) hash
{
  abort ();
}

-(id) initWithInternal: (id <TLString>) i external: (id <TLString>) e
{
  [super init];

  internal = i;
  external = e;

  return self;
}

-(id <TLString>) internal
{
  return internal;
}

-(id) internal: (id) s
{
  if (!s)
    abort ();

  print (internal, s, NO);
  return s;
}

-(id <TLString>) external
{
  return external;
}

-(id <TLString>) external: (id) s
{
  if (!s)
    abort ();

  print (external, s, NO);
  return s;
}

-(void) print: (id) s quoted: (BOOL) qp
{
  formac (s, @"[NAME: %@]", internal);
}

@end
