/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIStringCST.h,v 1.6 1998/01/05 00:57:15 tiggr Exp $  */

#import "lti.h"

@interface LTIStringCST: LTTTop
{
  /* The structural counterpart of this string.  */
  LTTStringCST *structure;
}

/* Forget all strings.  */
+(void) sufferAmnesia;

/* Return an enumerator on _all_ defined strings.  */
+(id <TLEnumerator>) allStrings;

/* Return an enumerator on all unique strings.  */
+(id <TLEnumerator>) strings;

/* Return the unique string for the STRING, or NIL if it could not be
   found.  */
+(LTIStringCST *) stringForString: (id <TLString>) string;

-(LTTStringCST *) structure;

#ifdef LTISTRINGCST_DECLARE_PRIVATE_METHODS

-initWithStructure: (LTTStringCST *) str;

#endif

@end
