/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTISelector.h,v 1.7 1998/01/05 00:57:13 tiggr Exp $  */

#import "lti.h"

@interface LTISelector: LTTTop
{
  /* Our structural counterpart.  */
  LTTSelector *structure;

  /* Methods implementing this message.  */
  TLVector *methods;

  /* Our unique id.  */
  int identity;
}

+(LTISelector *) selectorIdentified: (int) identity;

/* Return the number of allocated selectors.  For all selectors, 0 <=
   identity < numSelectors.  */
+(int) numSelectors;

/* Return an enumerator on all selectors semantics.  */
+(TLVector *) selectors;

-(void) addMethod: (LTIMethod *) m;

-(int) identity;

-(TLVector *) methods;

-(LTTSelector *) structure;

#ifdef LTISELECTOR_DECLARE_PRIVATE_METHODS

-initWithSelector: (LTTSelector *) sel;

#endif

@end
