<copyright> The od utility.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright (C) 1996 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: od.t,v 1.8 1998/01/05 00:55:41 tiggr Exp $</id>
    </copyright>

implementation class od: stdio, Constants

void
  usage
{
  [[out print ("usage: ", [Runtime program_name], " file")] nl];

  [Runtime exit 1];
}

int
  main Array arguments
{
  int i, n = [arguments length];
  String filename;
  InputStream f;

  for (i = 0; i < n; i++)
    {
      ByteString a = arguments[i];

      if (!filename)
	filename = a;
      else
	[self usage];
    }

  if (!filename)
    [self usage];

  f = [BufferedStream with [File open filename input: YES
				 flags: FILE_NOT_EXIST_RAISE]];

  MutableByteString s = [MutableByteString new];
  int c, offset;

  ["................" write s];

  while (c != -1)
    {
      int i;

      for (i = 0; i < 16; i++)
	{
	  c = [f read];
	  if (c == -1)
	    break;
	  else
	    {
	      if (i == 0)
		[out print offset base: 16 space: 8 flush: 1];
	      [out print c base: 16 space: 3 flush: 1];

	      if (byte (c) < ' ' || byte (c) > '~')
		c = '.';
	      s[i] = byte (c);
	    }
	}

      if (i != 0)
	{
	  offset += i;

	  while (i < 16)
	    {
	      [" **" write out];
	      s[i++] = '*';
	    }

	  [[s write ["  " write out]] nl];
	}
    }

  [f close];

  = 0;
}

end;

implementation instance od end;
