/*
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: mips.h,v 1.4 1999/01/05 11:55:51 tiggr Exp $  */

/* Created by Shawn Pearce during port to Irix 6 */

/* XXX Too broad; drop FP regs.  --Tiggr */
#define REG_PROT_START	0
#define REG_PROT_END	(sizeof (jmp_buf) / sizeof (void *))

#define VA_ARG_BYTE(AP)  (va_arg ((AP), tom_int))
#define VA_ARG_CHAR(AP)  (va_arg ((AP), tom_int))

/********************

 XXX This is for the O32 ABI.  Template N32 stuff (commented out) below.

 ********************/

#define BUILTIN_RETURN_TYPE  \
union						\
{						\
  struct { tom_int i; } i;			\
  struct { tom_long l; } l;			\
  struct { void *p; } p;			\
  struct { tom_int a, b; double d; } d;	\
  struct { tom_int a, b; double f; } f;	\
}

#define APPLY_ARGS_REG_SIZE  (4 * sizeof (tom_int) + 4 + 2 * sizeof (double))

#define APPLY_ARGS_START(SEL)  \
  do									\
    {									\
      int offset = 0;							\
      int reserved_size = (2 * sizeof (void *)				\
			   + sizeof (void *) * (SEL)->out->num		\
			   + sizeof (tom_double) * (SEL)->in->num)

#define APPLY_ARGS_STACK_SIZE(SEL)  \
  reserved_size

/* Macro local to this target file to emit a value of some non-floating type
   to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT_VALUE(TYPE, VALUE)  \
({	       						\
    TYPE *addr;						\
    if (offset < 16)					\
      addr = (void *) &args->reg[4 + offset];		\
    else						\
      addr = (char *) args->stack + (offset - 16);	\
    offset += sizeof (TYPE);				\
    *addr = (VALUE);					\
    (void *) addr;})

/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add an int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_int, VALUE)

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
    ({							\
      tom_long *addr;					\
      offset = (offset + 7) & ~7;			\
      if (offset < 12)					\
	addr = (void *) &args->reg[4 + offset];		\
      else						\
	addr = (char *) args->stack + offset - 16;	\
      offset += sizeof (tom_long);			\
      *addr = (VALUE);					\
      addr;						\
    });

/* Add a float value to the ARGS being built.    */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
  APPLY_ARGS_EMIT_DOUBLE (VALUE)

/* XXX incorrect... */
/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
  ({						\
    double val = (VALUE);			\
    APPLY_ARGS_EMIT_LONG (*(tom_long *) &val);	\
  })

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (void *, VALUE)

#define APPLY_ARGS_ACTUAL_SIZE()  \
  (offset < 16 ? 0 : offset - 16)

#define APPLY_ARGS_END()  \
    } while (0)

#if 0
/* This is (almost) for the N32 ABI.  */

#define BUILTIN_RETURN_TYPE  \
union						\
{						\
  struct { tom_int i; } i;			\
  struct { tom_long l; } l;			\
  struct { void *p; } p;			\
  struct { tom_int a, b; double d; } d;	\
  struct { tom_int a, b; double f; } f;	\
}

#define APPLY_ARGS_REG_SIZE  (8 * sizeof (tom_long) + 8 * sizeof (double))

#define APPLY_ARGS_START(SEL)  \
  do									\
    {									\
      int offset = 0;							\
      int reserved_size = (sizeof (void *) * (SEL)->out->num		\
			   + sizeof (tom_double) * (SEL)->in->num)

#define APPLY_ARGS_STACK_SIZE(SEL)  \
      reserved_size

/* Macro local to this target file to emit a value of some non-floating type
   to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT_VALUE(TYPE, VALUE)  \
({	       								\
    TYPE *addr;								\
    if (offset < 72)							\
      addr = (void *) &args->reg[offset];				\
    else								\
      addr = (char *) args->stack + (offset - 72);			\
    offset += sizeof (tom_long);					\
    *addr = (VALUE);							\
    (void *) addr;})

/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add an int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_long, VALUE)

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_long, VALUE)

/* Add a float value to the ARGS being built.    */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
  APPLY_ARGS_EMIT_DOUBLE (VALUE)

/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
({	       								\
    double *addr;							\
    if (offset < 72)							\
      addr = (void *) &args->reg[offset + 64];				\
    else								\
      addr = (char *) args->stack + (offset - 72);			\
    offset += sizeof (double);						\
    *addr = (VALUE);							\
    (void *) addr;})

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (void *, VALUE)

#define APPLY_ARGS_ACTUAL_SIZE()  \
  (offset < 72 ? 0 : offset - 72)

#define APPLY_ARGS_END()  \
    } while (0)
#endif
