#
#Tcl library for TkCVS
#

#
# $Id: filebrowse.tcl,v 1.4.2.6 1999/10/28 03:57:09 dorothyr Exp $
#
# Sets up a dialog to browse the contents of a module.
#

proc browse_files {mcode} {
  global filenames
  global mtitle
  global checkout_version

  static {browser 0}

  if {! [info exists mtitle($mcode)]} {
    cvsfail "Sorry, this function only works on modules, not directories!"
    return
  }

  # Find the list of file names.
  find_filenames $mcode

  if {! [info exists filenames($mcode)]} {
    cvsfail "There are no files in this module!"
    return
  }

  #
  # Create the browser window.
  #

  incr browser
  set filebrowse ".filebrowse$browser"
  toplevel $filebrowse
  frame $filebrowse.up   -relief groove -border 2
  frame $filebrowse.up.left
  frame $filebrowse.up.right
  frame $filebrowse.down -relief groove -border 2

  pack $filebrowse.up -side top -fill x
  pack $filebrowse.up.left -side left -fill both
  pack $filebrowse.up.right -side left -fill both -expand 1
  pack $filebrowse.down -side bottom -fill x

  label $filebrowse.lver1 -anchor w -text "Version / Tag "
  # label $filebrowse.lver2 -anchor w -text "Version / Tag 2 (diff)"

  entry $filebrowse.tver1 -relief sunken -textvariable checkout_version
  # bind_motifentry $filebrowse.tver1
  # entry $filebrowse.tver2 -relief sunken
  # bind_motifentry $filebrowse.tver2

  pack $filebrowse.lver1 -in $filebrowse.up.left \
    -side top -fill x -pady 3
  pack $filebrowse.tver1 -in $filebrowse.up.right \
    -side top -fill x -pady 3

  #
  # Create buttons
  #

  button $filebrowse.help -text "Help" \
    -command file_browser
  button $filebrowse.view -text "View" \
    -command "fileview $filebrowse $mcode"
  button $filebrowse.log -text "Log Browse" \
    -command "filelog $filebrowse.list $mcode"
  button $filebrowse.tag -text "Tags" \
    -command "tagview $filebrowse $mcode"
  # button $filebrowse.diff -text "Diff" \
  #   -command "filediff $filebrowse $mcode"
  button $filebrowse.quit -text "Quit" \
    -command "destroy $filebrowse"
  pack $filebrowse.help $filebrowse.view \
    $filebrowse.log $filebrowse.tag $filebrowse.quit \
    -in $filebrowse.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  #
  # Create a scrollbar and a list box.
  #

  scrollbar $filebrowse.scroll -relief sunken \
    -command "$filebrowse.list yview"
  listbox $filebrowse.list \
    -yscroll "$filebrowse.scroll set" -relief sunken \
    -width 40 -height 25 -setgrid yes
  pack $filebrowse.scroll -side right -fill y -padx 2 -pady 2
  pack $filebrowse.list -side left -fill both -expand 1

  #
  # Window manager stuff.
  #

  wm title $filebrowse "Files in $mcode"
  wm minsize $filebrowse 1 1

  #
  # Fill the list.
  #
  foreach file $filenames($mcode) {
    $filebrowse.list insert end $file
  }
}

proc filelog {listname mcode} {

  #puts "filelog {$listname $mcode}"
  foreach item [$listname curselection] {
    cvs_filelog $mcode [$listname get $item]
  }
}

# proc filediff {toplevelname mcode} {
# 
#   set listname $toplevelname.list
#   foreach item [$listname curselection] {
#     cvs_filediff $mcode [$listname get $item] \
#      [$toplevelname.tver1 get] [$toplevelname.tver2 get] 
#   }
# }

proc fileview {toplevelname mcode} {

  set listname $toplevelname.list
  foreach item [$listname curselection] {
    cvs_fileview $mcode [$listname get $item] [$toplevelname.tver1 get]
  }
}

proc tagview {toplevelname mcode} {

  #puts "proc tagview $toplevelname $mcode"
  set listname $toplevelname.list
  foreach item [$listname curselection] {
    filebrowse_tagview $mcode [$listname get $item]
  }
}

proc filebrowse_tagview {mcode filename} {
  global cvs
  global location
  global cvscfg
  global cwd

  set pid [pid]
  #puts "filebrowse_tagview {$mcode $filename}"
  set file $location($mcode)/$filename
  set filetail [file tail $filename]
  
  # Big note: the temp directory fed to a remote servers's command line
  # needs to be seen by the server.  It can't cd to an absolute path.
  # In addition it's fussy about where you are when you do a checkout -d.
  # Best avoid that altogether.
  cd $cvscfg(tmpdir)
  if {! [file isdirectory cvstmpdir.$pid]} {
    set ret [catch {eval exec mkdir cvstmpdir.$pid} view_this]
    if {$ret} {
      cvsfail $view_this
      cd $cwd
      return
    }
  }

  cd cvstmpdir.$pid

  #puts "$cvs -d $cvscfg(cvsroot) -l checkout $mcode/$filename"
  set ret [catch {eval "exec \
      $cvs -d $cvscfg(cvsroot) -l checkout $mcode/$filename" \
    } view_this]
  if {$ret} {
    cvsfail $view_this
    cd $cwd
    return
  }

  cd $mcode
  #puts "$cvs -d $cvscfg(cvsroot) -l status -v $filename"
  catch {eval "exec \
    $cvs -d $cvscfg(cvsroot) -l status -v $filename > tags.$filename"}

  set tagfile [open tags.$filename r]
  while { [ eof $tagfile ] == 0 } {
    gets $tagfile statline
    #puts "$statline"
    if {[string index $statline 0] == "\t" } {
      append keepers "$statline\n"
    }
  }
  close $tagfile
  cd $cwd

  view_output "$filename Tags" $keepers
}

