
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: polyrseq.m,v 1.2 1999/07/06 19:48:12 stes Exp $
 */

#include "cakit.h"

@implementation recpolscalar_sequence
- _setUpContent:aPolynomial
{
  assert ([aPolynomial isRecursive]);
  content = aPolynomial;
  eachTerm = [aPolynomial eachTerm];
  eachScalar = nil;
  return self;
}

+ content:aPolynomial
{
  return [[super new] _setUpContent:aPolynomial];
}

- toFirst
{
  if (eachScalar)
    eachScalar = nil;
  [eachTerm toFirst];
  return self;
}

- toLast
{
  if (eachScalar)
    eachScalar = nil;
  [eachTerm toLast];
  return self;
}

- (BOOL) isEmpty
{
  return [eachTerm isEmpty];
}

- (unsigned) size
{
  [self notImplemented:_cmd];
  return 0;
}

- toElementAt:(int)i
{
  [self notImplemented:_cmd];
  return self;
}

- next
{
  id next;

  if (eachScalar)
    {
      if (next = [eachScalar next])
	return next;
    }

  if (next = [eachTerm next])
    {
      id c = [next coefficient];
      if ([c sameClass:[content scalarZero]])
	{
	  return c;
	}
      else
	{
	  eachScalar = [[c eachScalar] toFirst];
	  return [self next];
	}
    }
  else
    {
      return nil;
    }
}

- previous
{
  id prevMember;

  if (eachScalar)
    {
      if (prevMember = [eachScalar previous])
	return prevMember;
    }

  if (prevMember = [eachTerm previous])
    {
      id c = [prevMember coefficient];
      if ([c sameClass:[content scalarZero]])
	{
	  return c;
	}
      else
	{
	  eachScalar = [[c eachScalar] toLast];
	  return [self previous];
	}
    }
  else
    {
      return nil;
    }
}

@end
 
