/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */


#include "InlineStmt.h"
#include "Bytecode.h"

void InlineStmt::Emit(Bytecode &b)
{
	int oldReturn, localReturn;
	
	oldReturn = b.GetReturnLabel();
	localReturn = b.NewLabel();
	
	b.SetReturnLabel(localReturn);
	
	BlockStmt::Emit(b);
	
	b.SetLabel(localReturn);
	b.SetReturnLabel(oldReturn);
}


InlineStmt* InlineStmt::Clone(Mapping *b) const
{
	// this never really gets called because cloning happens before
	// InlineStmts are substituted for CallStmts.
	
	InlineStmt *is = new InlineStmt();
	
	for(const Stmt *s = GetHead(); s; s=s->GetNext())
		is->Add(s->Clone(b));
	
	return is;
}
