/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text.rtf;

import com.sun.java.swing.text.AttributeSet;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.MutableAttributeSet;
import com.sun.java.swing.text.Segment;
import com.sun.java.swing.text.SimpleAttributeSet;
import com.sun.java.swing.text.Style;
import com.sun.java.swing.text.StyleConstants;
import com.sun.java.swing.text.TabStop;
import com.sun.java.swing.text.rtf.RTFAttribute;
import com.sun.java.swing.text.rtf.RTFAttributes;
import com.sun.java.swing.text.rtf.RTFReader;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class RTFGenerator {
    Dictionary colorTable = new Hashtable();
    int colorCount;
    Dictionary fontTable;
    int fontCount;
    Dictionary styleTable;
    int styleCount;
    OutputStream outputStream;
    boolean afterKeyword;
    MutableAttributeSet outputAttributes;
    int unicodeCount;
    private Segment workingSegment;
    int[] outputConversion;
    public static final Color defaultRTFColor = Color.black;
    public static final float defaultFontSize = 12.0f;
    public static final String defaultFontFamily = "Helvetica";
    protected static Integer One = new Integer(1);
    protected static Integer Zero = new Integer(0);
    protected static Boolean False = new Boolean(false);
    protected static Float ZeroPointZero;
    private static Object MagicToken;
    protected static CharacterKeywordPair[] textKeywords;
    static final char[] hexdigits;

    public static void writeDocument(Document document, OutputStream outputStream) throws IOException {
        RTFGenerator rTFGenerator = new RTFGenerator(outputStream);
        Element element = document.getDefaultRootElement();
        rTFGenerator.examineElement(element);
        rTFGenerator.writeRTFHeader();
        rTFGenerator.writeDocumentProperties(document);
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            rTFGenerator.writeParagraphElement(element.getElement(n2));
            ++n2;
        }
        rTFGenerator.writeRTFTrailer();
    }

    public RTFGenerator(OutputStream outputStream) {
        this.colorTable.put(defaultRTFColor, new Integer(0));
        this.colorCount = 1;
        this.fontTable = new Hashtable();
        this.fontCount = 0;
        this.styleTable = new Hashtable();
        this.styleCount = 0;
        this.workingSegment = new Segment();
        this.outputStream = outputStream;
        this.unicodeCount = 1;
    }

    public void examineElement(Element element) {
        AttributeSet attributeSet = element.getAttributes();
        this.tallyStyles(attributeSet);
        if (attributeSet != null) {
            String string;
            Object object;
            Color color = StyleConstants.getForeground(attributeSet);
            if (color != null && this.colorTable.get(color) == null) {
                this.colorTable.put(color, new Integer(this.colorCount));
                ++this.colorCount;
            }
            if ((object = attributeSet.getAttribute(StyleConstants.Background)) != null && this.colorTable.get(object) == null) {
                this.colorTable.put(object, new Integer(this.colorCount));
                ++this.colorCount;
            }
            if ((string = StyleConstants.getFontFamily(attributeSet)) == null) {
                string = defaultFontFamily;
            }
            if (string != null && this.fontTable.get(string) == null) {
                this.fontTable.put(string, new Integer(this.fontCount));
                ++this.fontCount;
            }
        }
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            this.examineElement(element.getElement(n2));
            ++n2;
        }
    }

    private void tallyStyles(AttributeSet attributeSet) {
        while (attributeSet != null) {
            Integer n;
            if (attributeSet instanceof Style && (n = (Integer)this.styleTable.get(attributeSet)) == null) {
                ++this.styleCount;
                n = new Integer(this.styleCount);
                this.styleTable.put(attributeSet, n);
            }
            attributeSet = attributeSet.getResolveParent();
        }
    }

    private Style findStyle(AttributeSet attributeSet) {
        while (attributeSet != null) {
            Object v;
            if (attributeSet instanceof Style && (v = this.styleTable.get(attributeSet)) != null) {
                return (Style)attributeSet;
            }
            attributeSet = attributeSet.getResolveParent();
        }
        return null;
    }

    private Integer findStyleNumber(AttributeSet attributeSet, String string) {
        while (attributeSet != null) {
            Integer n;
            if (attributeSet instanceof Style && (n = (Integer)this.styleTable.get(attributeSet)) != null && (string == null || string.equals(((Style)attributeSet).getAttribute("style:type")))) {
                return n;
            }
            attributeSet = attributeSet.getResolveParent();
        }
        return null;
    }

    private static Object attrDiff(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, Object object, Object object2) {
        Object object3 = mutableAttributeSet.getAttribute(object);
        Object object4 = attributeSet.getAttribute(object);
        if (object4 == object3) {
            return null;
        }
        if (object4 == null) {
            mutableAttributeSet.removeAttribute(object);
            if (object2 != null && !object2.equals(object3)) {
                return object2;
            }
            return null;
        }
        if (object3 == null || !RTFGenerator.equalArraysOK(object3, object4)) {
            mutableAttributeSet.addAttribute(object, object4);
            return object4;
        }
        return null;
    }

    private static boolean equalArraysOK(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.equals(object2)) {
            return true;
        }
        if (!object.getClass().isArray() || !object2.getClass().isArray()) {
            return false;
        }
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = (Object[])object2;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!RTFGenerator.equalArraysOK(objectArray[n2], objectArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void writeLineBreak() throws IOException {
        this.writeRawString("\n");
        this.afterKeyword = false;
    }

    public void writeRTFHeader() throws IOException {
        Object object;
        Object object2;
        Object object3;
        this.writeBegingroup();
        this.writeControlWord("rtf", 1);
        this.writeControlWord("ansi");
        this.outputConversion = RTFGenerator.outputConversionForName("ansi");
        this.writeLineBreak();
        String[] stringArray = new String[this.fontCount];
        Enumeration enumeration = this.fontTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object3 = (Color[])this.fontTable.get(string);
            stringArray[((Integer)object3).intValue()] = string;
        }
        this.writeBegingroup();
        this.writeControlWord("fonttbl");
        int n = 0;
        while (n < this.fontCount) {
            this.writeControlWord("f", n);
            this.writeControlWord("fnil");
            this.writeText(stringArray[n]);
            this.writeText(";");
            ++n;
        }
        this.writeEndgroup();
        this.writeLineBreak();
        if (this.colorCount > 1) {
            Object object4;
            object3 = new Color[this.colorCount];
            object2 = this.colorTable.keys();
            while (object2.hasMoreElements()) {
                object4 = (Color)object2.nextElement();
                object = (Integer)this.colorTable.get(object4);
                object3[((Integer)object).intValue()] = object4;
            }
            this.writeBegingroup();
            this.writeControlWord("colortbl");
            n = 0;
            while (n < this.colorCount) {
                object4 = object3[n];
                if (object4 != null) {
                    this.writeControlWord("red", ((Color)object4).getRed());
                    this.writeControlWord("green", ((Color)object4).getGreen());
                    this.writeControlWord("blue", ((Color)object4).getBlue());
                }
                this.writeRawString(";");
                ++n;
            }
            this.writeEndgroup();
            this.writeLineBreak();
        }
        if (this.styleCount > 1) {
            this.writeBegingroup();
            this.writeControlWord("stylesheet");
            object3 = this.styleTable.keys();
            while (object3.hasMoreElements()) {
                Boolean bl;
                Comparable<Boolean> comparable;
                Object object5;
                object2 = (Style)object3.nextElement();
                int n2 = (Integer)this.styleTable.get(object2);
                this.writeBegingroup();
                object = (String)object2.getAttribute("style:type");
                if (object == null) {
                    object = "paragraph";
                }
                if (((String)object).equals("character")) {
                    this.writeControlWord("*");
                    this.writeControlWord("cs", n2);
                } else if (((String)object).equals("section")) {
                    this.writeControlWord("*");
                    this.writeControlWord("ds", n2);
                } else {
                    this.writeControlWord("s", n2);
                }
                AttributeSet attributeSet = object2.getResolveParent();
                SimpleAttributeSet simpleAttributeSet = attributeSet == null ? new SimpleAttributeSet() : new SimpleAttributeSet(attributeSet);
                this.updateSectionAttributes(simpleAttributeSet, (AttributeSet)object2, false);
                this.updateParagraphAttributes(simpleAttributeSet, (AttributeSet)object2, false);
                this.updateCharacterAttributes(simpleAttributeSet, (AttributeSet)object2, false);
                attributeSet = object2.getResolveParent();
                if (attributeSet != null && attributeSet instanceof Style && (object5 = (Integer)this.styleTable.get(attributeSet)) != null) {
                    this.writeControlWord("sbasedon", (Integer)object5);
                }
                if ((object5 = (Style)object2.getAttribute("style:nextStyle")) != null && (comparable = (Integer)this.styleTable.get(object5)) != null) {
                    this.writeControlWord("snext", (Integer)comparable);
                }
                if ((comparable = (Boolean)object2.getAttribute("style:hidden")) != null && ((Boolean)comparable).booleanValue()) {
                    this.writeControlWord("shidden");
                }
                if ((bl = (Boolean)object2.getAttribute("style:additive")) != null && bl.booleanValue()) {
                    this.writeControlWord("additive");
                }
                this.writeText(object2.getName());
                this.writeText(";");
                this.writeEndgroup();
            }
            this.writeEndgroup();
            this.writeLineBreak();
        }
        this.outputAttributes = new SimpleAttributeSet();
    }

    void writeDocumentProperties(Document document) throws IOException {
        boolean bl = false;
        int n = 0;
        while (n < RTFAttributes.attributes.length) {
            Object object;
            boolean bl2;
            RTFAttribute rTFAttribute = RTFAttributes.attributes[n];
            if (rTFAttribute.domain() == 3 && (bl2 = rTFAttribute.writeValue(object = document.getProperty(rTFAttribute.swingName()), this, false))) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.writeLineBreak();
        }
    }

    public void writeRTFTrailer() throws IOException {
        this.writeEndgroup();
        this.writeLineBreak();
    }

    protected void checkNumericControlWord(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, Object object, String string, float f, float f2) throws IOException {
        Object object2 = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, object, MagicToken);
        if (object2 != null) {
            float f3 = object2 == MagicToken ? f : ((Number)object2).floatValue();
            this.writeControlWord(string, Math.round(f3 * f2));
        }
    }

    protected void checkControlWord(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, RTFAttribute rTFAttribute) throws IOException {
        Object object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, rTFAttribute.swingName(), MagicToken);
        if (object != null) {
            if (object == MagicToken) {
                object = null;
            }
            rTFAttribute.writeValue(object, this, true);
        }
    }

    protected void checkControlWords(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, RTFAttribute[] rTFAttributeArray, int n) throws IOException {
        int n2 = rTFAttributeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            RTFAttribute rTFAttribute = rTFAttributeArray[n3];
            if (rTFAttribute.domain() == n) {
                this.checkControlWord(mutableAttributeSet, attributeSet, rTFAttribute);
            }
            ++n3;
        }
    }

    void updateSectionAttributes(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, boolean bl) throws IOException {
        Integer n;
        Object object;
        if (bl && (object = mutableAttributeSet.getAttribute("sectionStyle")) != (n = this.findStyleNumber(attributeSet, "section"))) {
            if (object != null) {
                this.resetSectionAttributes(mutableAttributeSet);
            }
            if (n != null) {
                this.writeControlWord("ds", n);
                mutableAttributeSet.addAttribute("sectionStyle", n);
            } else {
                mutableAttributeSet.removeAttribute("sectionStyle");
            }
        }
        this.checkControlWords(mutableAttributeSet, attributeSet, RTFAttributes.attributes, 2);
    }

    protected void resetSectionAttributes(MutableAttributeSet mutableAttributeSet) throws IOException {
        this.writeControlWord("sectd");
        int n = RTFAttributes.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            RTFAttribute rTFAttribute = RTFAttributes.attributes[n2];
            if (rTFAttribute.domain() == 2) {
                rTFAttribute.setDefault(mutableAttributeSet);
            }
            ++n2;
        }
        mutableAttributeSet.removeAttribute("sectionStyle");
    }

    void updateParagraphAttributes(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, boolean bl) throws IOException {
        Object object;
        Object object2;
        Integer n;
        Object object3;
        if (bl) {
            object3 = mutableAttributeSet.getAttribute("paragraphStyle");
            if (object3 != (n = this.findStyleNumber(attributeSet, "paragraph")) && object3 != null) {
                this.resetParagraphAttributes(mutableAttributeSet);
                object3 = null;
            }
        } else {
            object3 = null;
            n = null;
        }
        if ((object2 = mutableAttributeSet.getAttribute("tabs")) != (object = attributeSet.getAttribute("tabs")) && object2 != null) {
            this.resetParagraphAttributes(mutableAttributeSet);
            object2 = null;
            object3 = null;
        }
        if (object3 != n && n != null) {
            this.writeControlWord("s", n);
            mutableAttributeSet.addAttribute("paragraphStyle", n);
        }
        this.checkControlWords(mutableAttributeSet, attributeSet, RTFAttributes.attributes, 1);
        if (object2 != object && object != null) {
            TabStop[] tabStopArray = (TabStop[])object;
            int n2 = 0;
            while (n2 < tabStopArray.length) {
                TabStop tabStop = tabStopArray[n2];
                switch (tabStop.getAlignment()) {
                    case 1: {
                        this.writeControlWord("tqr");
                        break;
                    }
                    case 2: {
                        this.writeControlWord("tqc");
                        break;
                    }
                    case 4: {
                        this.writeControlWord("tqdec");
                        break;
                    }
                }
                switch (tabStop.getLeader()) {
                    case 1: {
                        this.writeControlWord("tldot");
                        break;
                    }
                    case 2: {
                        this.writeControlWord("tlhyph");
                        break;
                    }
                    case 3: {
                        this.writeControlWord("tlul");
                        break;
                    }
                    case 4: {
                        this.writeControlWord("tlth");
                        break;
                    }
                    case 5: {
                        this.writeControlWord("tleq");
                        break;
                    }
                }
                int n3 = Math.round(20.0f * tabStop.getPosition());
                if (tabStop.getAlignment() == 5) {
                    this.writeControlWord("tb", n3);
                } else {
                    this.writeControlWord("tx", n3);
                }
                ++n2;
            }
            mutableAttributeSet.addAttribute("tabs", tabStopArray);
        }
    }

    public void writeParagraphElement(Element element) throws IOException {
        this.updateParagraphAttributes(this.outputAttributes, element.getAttributes(), true);
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            this.writeTextElement(element.getElement(n2));
            ++n2;
        }
        this.writeControlWord("par");
        this.writeLineBreak();
    }

    protected void resetParagraphAttributes(MutableAttributeSet mutableAttributeSet) throws IOException {
        this.writeControlWord("pard");
        mutableAttributeSet.addAttribute(StyleConstants.Alignment, Zero);
        int n = RTFAttributes.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            RTFAttribute rTFAttribute = RTFAttributes.attributes[n2];
            if (rTFAttribute.domain() == 1) {
                rTFAttribute.setDefault(mutableAttributeSet);
            }
            ++n2;
        }
        mutableAttributeSet.removeAttribute("paragraphStyle");
        mutableAttributeSet.removeAttribute("tabs");
    }

    void updateCharacterAttributes(MutableAttributeSet mutableAttributeSet, AttributeSet attributeSet, boolean bl) throws IOException {
        Object object;
        Integer n;
        Object object2;
        if (bl && (object2 = mutableAttributeSet.getAttribute("characterStyle")) != (n = this.findStyleNumber(attributeSet, "character"))) {
            if (object2 != null) {
                this.resetCharacterAttributes(mutableAttributeSet);
            }
            if (n != null) {
                this.writeControlWord("cs", n);
                mutableAttributeSet.addAttribute("characterStyle", n);
            } else {
                mutableAttributeSet.removeAttribute("characterStyle");
            }
        }
        if ((object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, StyleConstants.FontFamily, null)) != null) {
            object2 = (Number)this.fontTable.get(object);
            this.writeControlWord("f", ((Number)object2).intValue());
        }
        this.checkNumericControlWord(mutableAttributeSet, attributeSet, StyleConstants.FontSize, "fs", 12.0f, 2.0f);
        this.checkControlWords(mutableAttributeSet, attributeSet, RTFAttributes.attributes, 0);
        this.checkNumericControlWord(mutableAttributeSet, attributeSet, StyleConstants.LineSpacing, "sl", 0.0f, 20.0f);
        object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, StyleConstants.Background, MagicToken);
        if (object != null) {
            int n2 = object == MagicToken ? 0 : ((Number)this.colorTable.get(object)).intValue();
            this.writeControlWord("cb", n2);
        }
        if ((object = RTFGenerator.attrDiff(mutableAttributeSet, attributeSet, StyleConstants.Foreground, null)) != null) {
            int n3 = object == MagicToken ? 0 : ((Number)this.colorTable.get(object)).intValue();
            this.writeControlWord("cf", n3);
        }
    }

    protected void resetCharacterAttributes(MutableAttributeSet mutableAttributeSet) throws IOException {
        this.writeControlWord("plain");
        int n = RTFAttributes.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            RTFAttribute rTFAttribute = RTFAttributes.attributes[n2];
            if (rTFAttribute.domain() == 0) {
                rTFAttribute.setDefault(mutableAttributeSet);
            }
            ++n2;
        }
        StyleConstants.setFontFamily(mutableAttributeSet, defaultFontFamily);
        mutableAttributeSet.removeAttribute(StyleConstants.FontSize);
        mutableAttributeSet.removeAttribute(StyleConstants.Background);
        mutableAttributeSet.removeAttribute(StyleConstants.Foreground);
        mutableAttributeSet.removeAttribute(StyleConstants.LineSpacing);
        mutableAttributeSet.removeAttribute("characterStyle");
    }

    public void writeTextElement(Element element) throws IOException {
        this.updateCharacterAttributes(this.outputAttributes, element.getAttributes(), true);
        if (element.isLeaf()) {
            try {
                element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset(), this.workingSegment);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                throw new InternalError(badLocationException.getMessage());
            }
            this.writeText(this.workingSegment);
            return;
        }
        int n = element.getElementCount();
        int n2 = 0;
        while (n2 < n) {
            this.writeTextElement(element.getElement(n2));
            ++n2;
        }
    }

    public void writeText(Segment segment) throws IOException {
        int n = segment.offset;
        int n2 = n + segment.count;
        char[] cArray = segment.array;
        while (n < n2) {
            this.writeCharacter(cArray[n]);
            ++n;
        }
    }

    public void writeText(String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            this.writeCharacter(string.charAt(n));
            ++n;
        }
    }

    public void writeRawString(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.outputStream.write(string.charAt(n2));
            ++n2;
        }
    }

    public void writeControlWord(String string) throws IOException {
        this.outputStream.write(92);
        this.writeRawString(string);
        this.afterKeyword = true;
    }

    public void writeControlWord(String string, int n) throws IOException {
        this.outputStream.write(92);
        this.writeRawString(string);
        this.writeRawString(String.valueOf(n));
        this.afterKeyword = true;
    }

    public void writeBegingroup() throws IOException {
        this.outputStream.write(123);
        this.afterKeyword = false;
    }

    public void writeEndgroup() throws IOException {
        this.outputStream.write(125);
        this.afterKeyword = false;
    }

    public void writeCharacter(char c) throws IOException {
        if (c == '\u00a0') {
            this.outputStream.write(92);
            this.outputStream.write(126);
            this.afterKeyword = false;
            return;
        }
        if (c == '\t') {
            this.writeControlWord("tab");
            return;
        }
        if (c == '\n' || c == '\r') {
            return;
        }
        int n = RTFGenerator.convertCharacter(this.outputConversion, c);
        if (n == 0) {
            int n2 = 0;
            while (n2 < textKeywords.length) {
                if (RTFGenerator.textKeywords[n2].character == c) {
                    this.writeControlWord(RTFGenerator.textKeywords[n2].keyword);
                    return;
                }
                ++n2;
            }
            String string = this.approximationForUnicode(c);
            if (string.length() != this.unicodeCount) {
                this.unicodeCount = string.length();
                this.writeControlWord("uc", this.unicodeCount);
            }
            this.writeControlWord("u", c);
            this.writeRawString(" ");
            this.writeRawString(string);
            this.afterKeyword = false;
            return;
        }
        if (n > 127) {
            this.outputStream.write(92);
            this.outputStream.write(39);
            int n3 = (n & 0xF0) >>> 4;
            this.outputStream.write(hexdigits[n3]);
            n3 = n & 0xF;
            this.outputStream.write(hexdigits[n3]);
            this.afterKeyword = false;
            return;
        }
        switch (n) {
            case 92: 
            case 123: 
            case 125: {
                this.outputStream.write(92);
                this.afterKeyword = false;
            }
        }
        if (this.afterKeyword) {
            this.outputStream.write(32);
            this.afterKeyword = false;
        }
        this.outputStream.write(n);
    }

    String approximationForUnicode(char c) {
        return "?";
    }

    static int[] outputConversionFromTranslationTable(char[] cArray) {
        int[] nArray = new int[2 * cArray.length];
        int n = 0;
        while (n < cArray.length) {
            nArray[n * 2] = cArray[n];
            nArray[n * 2 + 1] = n;
            ++n;
        }
        return nArray;
    }

    static int[] outputConversionForName(String string) throws IOException {
        char[] cArray = (char[])RTFReader.getCharacterSet(string);
        return RTFGenerator.outputConversionFromTranslationTable(cArray);
    }

    protected static int convertCharacter(int[] nArray, char c) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] == c) {
                return nArray[n + 1];
            }
            n += 2;
        }
        return 0;
    }

    static {
        MagicToken = new Object();
        ZeroPointZero = new Float(0.0f);
        Dictionary dictionary = RTFReader.textKeywords;
        Enumeration enumeration = dictionary.keys();
        Vector<CharacterKeywordPair> vector = new Vector<CharacterKeywordPair>();
        while (enumeration.hasMoreElements()) {
            CharacterKeywordPair characterKeywordPair = new CharacterKeywordPair();
            characterKeywordPair.keyword = (String)enumeration.nextElement();
            characterKeywordPair.character = ((String)dictionary.get(characterKeywordPair.keyword)).charAt(0);
            vector.addElement(characterKeywordPair);
        }
        textKeywords = new CharacterKeywordPair[vector.size()];
        vector.copyInto(textKeywords);
        hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    static class CharacterKeywordPair {
        public char character;
        public String keyword;

        CharacterKeywordPair() {
        }
    }
}

