/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.BoundedRangeModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JProgressBar;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicProgressBarUI;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class MetalProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalProgressBarUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        BoundedRangeModel boundedRangeModel = jProgressBar.getModel();
        Dimension dimension = jProgressBar.getSize();
        Insets insets = jProgressBar.getInsets();
        Rectangle rectangle = new Rectangle(dimension);
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.right + rectangle.x;
        rectangle.height -= insets.bottom + rectangle.y;
        int n = this.getAmountFull(jComponent);
        if (jProgressBar.getOrientation() == 0) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.width, rectangle.y);
            if (boundedRangeModel.getValue() == boundedRangeModel.getMinimum()) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height);
            graphics.drawLine(rectangle.x, rectangle.y, n, rectangle.y);
            return;
        }
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.height);
        if (boundedRangeModel.getValue() == boundedRangeModel.getMinimum()) {
            graphics.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        }
        graphics.drawLine(rectangle.x, rectangle.height, rectangle.width, rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.height, rectangle.x, rectangle.height - n);
    }
}

