package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class RootExpr extends ConvertibleNodeSetExpr {
  private final NodeSetExpr expr;

  RootExpr(NodeSetExpr expr) {
    this.expr = expr;
  }

  public NodeIterator eval(Node node, ExprContext context) throws XSLException {
    for (;;) {
      Node tem = node.getParent();
      if (tem == null)
	break;
      node = tem;
    }
    return expr.eval(node, context);
  }
}
