/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *
 *	$Id: tfflush.c,v 6.3 1999/05/27 20:07:06 kmeyer1 Exp $
 *
 *	We are just putting our stamp on this for housekeeping reasons.
 */

/*
 * This file is originally from dLibs 1.2 by Dale Schumacher et al.
 * It was modified for Trollius by MB, 88/12.
 * It was modified again for portability by GDB, 91/08.
 * And yet again by JRV for LAM, 93/05.
 */

#include <sys/types.h>
#include <tstdio.h>

#include <laminternal.h>

/*
 *	implementation note:  This function has the side effect of
 *	re-aligning the virtual file pointer (in the buffer) with
 *	the actual file pointer (in the file) and is therefore used
 *	in other functions to accomplish this re-sync operation.
 */

static int
_fflush(fp)
	TFILE *fp;
{
	int f, rv = 0;
	long offset;

 	if(fp == NULL)
		return(0);
	f = fp->_flag;
	if((f & _TIONBF)			/* MB: file is not buffered */
	|| (!(f & (_TIOREAD | _TIOWRT))))		/* file not open! */
		return(0);
	if(fp->_cnt)				/* data in the buffer */
	{
		if(f & _TIORW)				/* writing */
		{
			if((lam_iomap_write(f, fp->_file, (char *) fp->_base,
				(long) fp->_cnt)) != fp->_cnt)
			{
				fp->_flag |= _TIOERR;
				rv = EOF;
			}

		} else {				/* reading */

			offset = (long) -(fp->_cnt);
			if(lam_iomap_lseek(f, fp->_file, offset, 1) < 0)
				rv = EOF;
		}
	}
	fp->_ptr = fp->_base;
	fp->_cnt = 0;
	return(rv);
}

int
tfflush(fp)
	TFILE *fp;
{
	int f, i;

 	if(fp)
		return(_fflush(fp));
	else {
		for(i=0; i<_TNFILE; ++i) {
			f = _tiob[i]._flag;
			if(f & (_TIOREAD | _TIOWRT))
				(void) _fflush(&_tiob[i]);
		}
		return(0);
	}
}
