/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: trecv.c,v 6.3 1999/05/26 18:22:04 kmeyer1 Exp $
 * 
 *	Function:	- transport layer receive
 */

#include <portable.h>
#include <typical.h>
#include <net.h>

#include <unistd.h>

int
trecv(nhead)

struct nmsg		*nhead;		/* network message descriptor */

{
	struct nmsg	sync;		/* synchronization message */
	int		save_event;	/* saved message event */
	int		ret;		/* returned value */
/*
 * Receive "ready to send" message.
 */
	sync.nh_event = nhead->nh_event;
	sync.nh_type = nhead->nh_type;
	sync.nh_flags = DINT4DATA;
	sync.nh_length = 0;
	sync.nh_msg = (char *) 0;

	if (nrecv(&sync)) return(LAMERROR);
/*
 * Send "ready to receive" to sending party.  Include the event to be used.
 */
	sync.nh_node = sync.nh_data[0];
	sync.nh_event = sync.nh_data[1];
	sync.nh_type = 0;
	sync.nh_flags = DINT4DATA;
	sync.nh_data[0] = -getpid();

	if (nsend(&sync)) return(LAMERROR);
/*
 * Receive the data message using the new event.
 */
	save_event = nhead->nh_event;
	nhead->nh_event = -getpid();

	ret = nrecv(nhead);

	nhead->nh_event = save_event;
	return(ret);
}
