/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: namelook.c,v 6.4 1999/06/03 02:13:18 kmeyer1 Exp $
 *
 *	Function:	- get port name associated with service name
 *	Accepts:	- service name
 *			- info
 *			- port name (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>


int
MPI_Lookup_name(service_name, info, port_name)

char			*service_name;
MPI_Info		info;
char			*port_name;

{
	char		*port_buf;
	
	lam_initerr();
	lam_setfunc(BLKMPILOOKUPNAME);
/*
 * Check arguments.
 */
	if (port_name == 0 || service_name == 0) {
		return(lam_err_comm(MPI_COMM_WORLD, MPI_ERR_ARG, 0, ""));
	}
/*
 * Get port name.
 */
	if (lam_getpublished(service_name, &port_buf)) {
		return(lam_err_comm(MPI_COMM_WORLD, MPI_ERR_NAME, errno, "")); 
	}

	strncpy(port_name, port_buf, MPI_MAX_PORT_NAME);
	free(port_buf);

        lam_resetfunc(BLKMPILOOKUPNAME);
	return(MPI_SUCCESS);
}
