/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/NJN
 *
 *	$Id: laminited.c,v 6.2 1999/05/25 22:08:05 kmeyer1 Exp $
 *
 *	Function:	- test if MPI has been initialized/finalized
 */

#include <stdio.h>
#include <unistd.h>

#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

/*
 * global variables
 */
int 			lam_flinit = 0;
int 			lam_flfinal = 0;

/*
 *	lam_inited
 *
 *	Function:	- check if MPI has been initialized
 *	Returns:	- TRUE or FALSE
 */
int
lam_inited()

{
/*
 * Using _kio_ki_pid works when a process is forked.
 *
 * return(_kio.ki_pid == getpid());
 */
	return(lam_flinit);
}

/*
 *	lam_finalized
 *
 *	Function:	- check if MPI has been finalized
 *	Returns:	- TRUE or FALSE
 */
int
lam_finalized()

{
	return(lam_flfinal);
}

/*
 *	lam_initerr
 *
 *	Function:	- if MPI not initialized, abort as an error
 */
void
lam_initerr()

{
	if (lam_flinit == 0) {
		LAMSetLastError(EMPINOINIT);
		fprintf(stderr, "MPI error: process not initialized\n");
		exit(LAM_EEXIT);
	}
}
