/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	RBD
 *
 *	$Id: ibsend.c,v 6.4 1999/11/12 05:19:29 jsquyres Exp $
 *
 *	Function:	- immediate buffered send
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *			- request (out)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>


/*
 * external functions
 */
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern int		lam_errfunc();
extern int		_mpi_req_build();

int
MPI_Ibsend(buf, count, dtype, dest, tag, comm, preq)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
MPI_Request		*preq;

{
	int		err;

	lam_initerr_m();
	lam_setfunc_m(BLKMPIIBSEND);
/*
 * Check the tag.
 */
	if (tag < 0 || tag > LAM_MAXTAG) {
		return(lam_errfunc(comm, BLKMPIIBSEND,
				lam_mkerr(MPI_ERR_TAG, 0)));
	}
/*
 * Create the fake user request.  We do not add it into the
 * request list.  This is an exception to the design that says
 * that all active (inc. done) requests are to be found in the
 * request list but fake requests, really ibsend requests are
 * very exceptional MPI creatures.
 */
	*preq = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, dest, tag, comm,
			LAM_RQIFAKE, preq);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIIBSEND, err));
	}

	(*preq)->rq_status.MPI_ERROR = MPI_SUCCESS;
	(*preq)->rq_status.MPI_TAG = MPI_UNDEFINED;
	(*preq)->rq_status.MPI_SOURCE = MPI_PROC_NULL;
	(*preq)->rq_state = LAM_RQSDONE;
/*
 * Bsend() the message.
 */
	err = MPI_Bsend(buf, count, dtype, dest, tag, comm);
	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPIIBSEND, err));
	}

	lam_resetfunc_m(BLKMPIIBSEND);
	return(MPI_SUCCESS);
}
