/*
This file is licensed to you under the license specified in the included file
`LICENSE'. Look there for further details.
*/


#include <stdlib.h>
#include <stdio.h>

extern int generate_main (void);

void gengetopt_free (void);

#include "argsdef.h"
#include "ggos.h"
struct gengetopt_option * gengetopt_options = NULL;
char * gengetopt_package = NULL;
char * gengetopt_version = NULL;
int gengetopt_count_line = 1;

int gengetopt_add_option (char * long_opt, char short_opt, char * desc,
			  int type, int flagstat_or_required);
int canonize_vars (void);


int
main (int argc, char **argv)
{
  switch  (gengetopt_add_option ("help", 'h', "Print help and exit", ARG_NO, 0))
  {
  case 1: fprintf (stderr, "gengetopt: line %d: not enough memory\n",
		   gengetopt_count_line);
	  return 1;
  case 2:
  case 3:
  case 4: fprintf (stderr, "gengetopt: buf found in %s:%d!!\n", __FILE__, __LINE__);
	  abort ();
  }
  switch  (gengetopt_add_option ("version", 'V', "Print version and exit", ARG_NO, 0))
  {
  case 1: fprintf (stderr, "gengetopt: line %d: not enough memory\n",
		   gengetopt_count_line);
	  return 1;
  case 2:
  case 3:
  case 4: fprintf (stderr, "gengetopt: buf found in %s:%d!!\n", __FILE__, __LINE__);
	  abort ();
  }

  if (yyparse ()) {
	gengetopt_free ();
	return 1;
  }

  if (canonize_vars ()) {
	gengetopt_free ();
	return 1;
  }

  if (generate_main ()) {
	gengetopt_free ();
	return 1;
  }

  gengetopt_free ();

  return 0;
}


/* ************* */


char *
gengetopt_strdup (char * s)
{
	char * n, * pn, * ps = s;
	while (*ps) ps++;
	n = malloc (1 + ps - s);
	if (n != NULL) {
		for (ps=s,pn=n; *ps; ps++,pn++) *pn = *ps;
		*pn = 0;
	}
	return n;
}


int
gengetopt_strcmp (char * s1, char * s2)
{
	char * p1, * p2;

	for (p1=s1,p2=s2; *p1&&*p2; p1++,p2++)
		if (*p1 < *p2) return -1;
		else if (*p1 > *p2) return 1;
	if (*p1 == 0)
		if (*p2 == 0) return 0;
		else return -1;
	else
		if (*p2 == 0) return 1;
		else { fprintf (stderr, "gengetopt: bug found in %s:%d!!\n",
				__FILE__, __LINE__); abort (); }
}


int
gengetopt_define_package (char * s)
{
	gengetopt_package = gengetopt_strdup (s);
	if (gengetopt_package == NULL)
		return 1;
	return 0;
}

int
gengetopt_define_version (char * s)
{
	gengetopt_version = gengetopt_strdup (s);
	if (gengetopt_version == NULL)
		return 1;
	return 0;
}

int
gengetopt_add_option (char * long_opt, char short_opt, char * desc,
		      int type, int flagstat_or_required)
{
	struct gengetopt_option * n;

	if (long_opt == NULL || long_opt[0] == 0 ||
	    desc == NULL || desc[0] == 0)
		return 4;

	/* search for collisions */
	for (n = gengetopt_options; n != NULL; n = n->next)
	{
		if (!gengetopt_strcmp (n->long_opt, long_opt)) return 2;
		if (n->short_opt == short_opt) return 3;
	}

	n = malloc (sizeof (struct gengetopt_option));
	if (n == NULL) return 1;

	n->long_opt = gengetopt_strdup (long_opt);
	if (n->long_opt == NULL) {
		free (n);
		return 1;
	}

	n->desc = gengetopt_strdup (desc);
	if (n->desc == NULL) {
		free (n->long_opt);
		free (n);
		return 1;
	}
	
	n->short_opt = short_opt;
	n->type = type;
	n->flagstat_or_required = flagstat_or_required;
	n->next = NULL;
	n->var_arg = NULL;

	/* if empty stack */
	if (gengetopt_options == NULL)
		gengetopt_options = n;
	else {
		struct gengetopt_option * p = gengetopt_options;
		while (p->next != NULL) p = p->next;
		p->next = n;
	}
	return 0;
}


void
gengetopt_free (void)
{
  struct gengetopt_option *p, *pnext;

  if (gengetopt_package != NULL) free (gengetopt_package);
  for (p = gengetopt_options; p != NULL; p = pnext)
  {
	pnext = p->next;
	if (p->long_opt != NULL) free (p->long_opt);
	if (p->desc != NULL) free (p->desc);
	if (p->var_arg != NULL) free (p->var_arg);
	free (p);
  }
}


int
canonize_vars (void)
{
  struct gengetopt_option *p;
  char *pvar;

  if (gengetopt_options == NULL) {
	printf ("gengetopt: bug found in %s:%d!!\n", __FILE__, __LINE__);
	abort ();
  }

  for (p = gengetopt_options; p != NULL; p = p->next)
  {
    p->var_arg = gengetopt_strdup (p->long_opt);
    if (p->var_arg == NULL) {
	printf ("gengetopt: not enough memory to canonize vars\n");
	return 1;
    }

    for (pvar = p->var_arg; *pvar; pvar++)
      if (*pvar == '.' || *pvar == '-') *pvar = '_';
  }
  return 0;
}

