-- Copyright 1998 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_COMMAND - attach these to widgets to perform actions %
	              % when something happens. Version for SmallEiffel"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	cvs: "$Id: gtk_command.e,v 1.3 1999/10/03 02:07:20 richieb Exp $"

deferred class GTK_COMMAND

inherit

	GTK_NON_PORTABLE_CALLS

feature

	execute is
			-- code to execute when the event occurs
		deferred
		end

	connect (new_event: STRING; new_parent: like parent) is
			-- connect command to a widget event
		require
			event_valid: new_event /= Void
			parent_valid: new_parent /= Void
			not_connected: not connected
		do
			event := new_event
			parent := new_parent
			gtk_command_id := c_gtk_signal_connect (parent.widget,
													event.to_external,
													Current)
			connected := True
		ensure
			connected
		end

	disconnect is
			-- remove the command from the widget
		require
			is_connected: connected
		do
			connected := False
			gtk_signal_disconnect (parent.widget, gtk_command_id)
			parent := Void
		end

	connected: BOOLEAN
			-- true if connected to a widget

	event: STRING
			-- name of the event

	parent: GTK_WIDGET
			-- parent widget

feature {NONE}

	gtk_command_id: INTEGER
			-- ID of this handler

end -- GTK_COMMAND
