-- Copyright (C) 1999 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "gtk_object - top class of GTK hierarchy"
	author: "Richie Bielak"
	version: "v 0.3.3 GTK+ 1.2.x"
	cvs: "$Id: gtk_object.e,v 1.5 1999/10/03 02:07:19 richieb Exp $"

class GTK_OBJECT

-- Top level of GTK hierarchy; handles actions
--
-- Signals (from gtkobject.c):
--    "destroy"

inherit
	
	GTK_OBJECT_EXTERNALS
		undefine
			copy, is_equal
		end

	GTK_SIGNAL_EXTERNALS
		undefine
			copy, is_equal
		end

	EGTK_NON_PORTABLE
		undefine
			copy, is_equal
		end

	EGTK_SHARED_WIDGET_FACTORY
		undefine
			copy, is_equal
		end

	GTK_IDENTIFIED

creation

	make_from_pointer

feature 

	gtk_object: POINTER
			-- pointer to the GTK+ structure

	make_from_pointer (p: POINTER) is
			-- make the eiffel object from a pointer to an existing 
			-- Gtk structure
		require
			valid_pointer: p /= default_pointer
		do
			gtk_object := p
		end

feature -- callbacks

	add_action, signal_connect (signal_name: STRING; cmd: GTK_COMMAND_TYPE) is
			-- add a command object to handle a specific signal
		require
			signal_name_not_void: signal_name /= Void
			cmd_not_void: cmd /= Void
			cmd_not_connected: cmd.parent = Void
		do
			if actions = Void then
				!!actions.make (1, 0)
			end
			-- keep track of cmd objects
			actions.force (cmd, actions.count + 1)
			-- call C function to connect the signal handler
			cmd.connect (signal_name, Current)
		ensure
			cmd_connected: cmd.parent = Current
		end

	action_by_name (signal_name: STRING): GTK_COMMAND_TYPE is
			-- return the command object by signal name
		require
			signal_name_not_void: signal_name /= Void
		local
			cmd: GTK_COMMAND_TYPE
			i: INTEGER
		do
			from i := 1
			until (i > actions.count) or (Result /= Void)
			loop
				cmd := actions.item (i)
				if cmd /= Void and then 
					signal_name.is_equal (cmd.event_name)
				 then
					Result := cmd
				end
				i := i + 1
			end
		end
	
	remove_action (old_cmd: GTK_COMMAND_TYPE) is
			-- remove callback
		require
			old_cmd_not_void: old_cmd /= Void
		local
			i: INTEGER
			cmd: GTK_COMMAND_TYPE
		do
			from i := 1
			until i > actions.count
			loop
				cmd := actions.item (i)
				if cmd = old_cmd then
					cmd.disconnect
					actions.put (Void, i)
				end
				i := i + 1
			end
		end

	remove_all_signal_handlers is
			-- remove all action handlers 
		do
			gtk_signal_handlers_destroy (gtk_object)
			actions := Void
		end
	
feature -- query

	flags: INTEGER is
			-- flags returns the sum of all flags set for this
			-- object: see GTK_CONSTANTS under Widget flags
		do
			Result := c_gtk_object_get_flags (gtk_object)
		end

feature {NONE}

	actions: ARRAY [GTK_COMMAND_TYPE]
			-- keep references to 

	register_widget is
			-- memory management
		do
			widget_factory.add_widget (gtk_object, gtk_object_id)
		end

invariant

--	gtk_object_not_void: gtk_object /= default_pointer

end -- GTK_OBJECT
