-- Copyright (C) 1999 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "GTK_LIST box widget"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	cvs: "$Id: gtk_list.e,v 1.6 1999/10/03 02:07:19 richieb Exp $"

class GTK_LIST

-- A list box widget
--
-- Signals (from gtklist.c):
--    "select_child"
--    "selection_changed"
--    "unselect_child"


inherit

	GTK_COMPOSED_BIN
		redefine
			add_widget
		end

	GTK_LIST_EXTERNALS
		undefine
			copy, is_equal
		end

	GTK_CONSTANTS
		undefine
			copy, is_equal
		end

creation

	make,
	make_from_pointer

feature

	make is 
		do
			!!children.make (1, 0)
			widget := gtk_list_new
			register_widget
		end

	add_widget (l_item: GTK_LIST_ITEM) is
			-- only allow list items to be added
		do
			precursor (l_item)
		end

	child_position (child: GTK_LIST_ITEM): INTEGER is
			-- position of this widget in the list
		require
			child_not_void: child /= Void
		do
			Result := gtk_list_child_position (widget, child.widget)
		end

feature -- selections

	select_item (it: INTEGER) is
		require
			valid_item_index: (it >= 0) and (it < count)
		do
			gtk_list_select_item (widget, it)
		end

	unselect_item (it: INTEGER) is
		require
			valid_item_index: (it >= 0) and (it < count)
		do
			gtk_list_unselect_item (widget, it)
		end


	set_selection_mode (mode: INTEGER) is
		require
			valid_mode: is_mode_valid (mode)
		do
			gtk_list_set_selection_mode (widget, mode)
		end

	is_mode_valid (mode: INTEGER): BOOLEAN is
		do
			Result := (mode = GTK_SELECTION_SINGLE) 
				or else (mode = GTK_SELECTION_BROWSE)
				or else (mode = GTK_SELECTION_MULTIPLE)
				or else (mode = GTK_SELECTION_EXTENDED)

		end

end -- GTK_LIST
