indexing
	description: "External C calls to the GTK library."
	gtk_klass: "GLIB"
	gtk_file: "glib.h"
	status: "See notice at end of class"
	signals: ""
	events: ""

class
	C_GLIB

feature -- External C functions

	g_list_push_allocator (a_allocator: POINTER) is 
			-- Parsed as:
			-- void g_list_push_allocator (
			--     GAllocator *a_allocator
			-- );
			--
			-- Original C code from glib.h:
			-- void   g_list_push_allocator    (GAllocator     *allocator);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_pop_allocator is 
			-- Parsed as:
			-- void g_list_pop_allocator (
			-- );
			--
			-- Original C code from glib.h:
			-- void   g_list_pop_allocator     (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_alloc: POINTER is 
			-- Parsed as:
			-- GList* g_list_alloc (
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_alloc		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_free (a_list: POINTER) is 
			-- Parsed as:
			-- void g_list_free (
			--     GList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- void   g_list_free		(GList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_free_1 (a_list: POINTER) is 
			-- Parsed as:
			-- void g_list_free_1 (
			--     GList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- void   g_list_free_1		(GList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_append (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_append (
			--     GList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_append		(GList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_prepend (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_prepend (
			--     GList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_prepend		(GList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_insert (a_list: POINTER; a_data: POINTER; a_position: INTEGER): POINTER is 
			-- Parsed as:
			-- GList* g_list_insert (
			--     GList *a_list,
			--     gpointer a_data,
			--     gint a_position
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_insert		(GList		*list,
			-- 				 gpointer	 data,
			-- 				 gint		 position);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_insert_sorted (a_list: POINTER; a_data: POINTER; a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_insert_sorted (
			--     GList *a_list,
			--     gpointer a_data,
			--     GCompareFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_insert_sorted	(GList		*list,
			-- 				 gpointer	 data,
			-- 				 GCompareFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_concat (a_list1: POINTER; a_list2: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_concat (
			--     GList *a_list1,
			--     GList *a_list2
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_concat		(GList		*list1,
			-- 				 GList		*list2);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_remove (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_remove (
			--     GList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_remove		(GList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_remove_link (a_list: POINTER; a_llink: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_remove_link (
			--     GList *a_list,
			--     GList *a_llink
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_remove_link	(GList		*list,
			-- 				 GList		*llink);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_reverse (a_list: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_reverse (
			--     GList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_reverse		(GList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_copy (a_list: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_copy (
			--     GList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_copy		(GList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_nth (a_list: POINTER; a_n: INTEGER): POINTER is 
			-- Parsed as:
			-- GList* g_list_nth (
			--     GList *a_list,
			--     guint a_n
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_nth		(GList		*list,
			-- 				 guint		 n);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_find (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_find (
			--     GList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_find		(GList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_find_custom (a_list: POINTER; a_data: POINTER; a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_find_custom (
			--     GList *a_list,
			--     gpointer a_data,
			--     GCompareFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_find_custom	(GList		*list,
			-- 				 gpointer	 data,
			-- 				 GCompareFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_position (a_list: POINTER; a_llink: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_list_position (
			--     GList *a_list,
			--     GList *a_llink
			-- );
			--
			-- Original C code from glib.h:
			-- gint   g_list_position		(GList		*list,
			-- 				 GList		*llink);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_index (a_list: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_list_index (
			--     GList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- gint   g_list_index		(GList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_last (a_list: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_last (
			--     GList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_last		(GList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_first (a_list: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_first (
			--     GList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_first		(GList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_length (a_list: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_list_length (
			--     GList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- guint  g_list_length		(GList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_foreach (a_list: POINTER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_list_foreach (
			--     GList *a_list,
			--     GFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void   g_list_foreach		(GList		*list,
			-- 				 GFunc		 func,
			-- 				 gpointer	 user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_sort (a_list: POINTER; a_compare_func: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_list_sort (
			--     GList *a_list,
			--     GCompareFunc a_compare_func
			-- );
			--
			-- Original C code from glib.h:
			-- GList* g_list_sort              (GList          *list,
			-- 		                 GCompareFunc    compare_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_list_nth_data (a_list: POINTER; a_n: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_list_nth_data (
			--     GList *a_list,
			--     guint a_n
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_list_nth_data	(GList		*list,
			-- 				 guint		 n);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_push_allocator (a_allocator: POINTER) is 
			-- Parsed as:
			-- void g_slist_push_allocator (
			--     GAllocator *a_allocator
			-- );
			--
			-- Original C code from glib.h:
			-- void    g_slist_push_allocator  (GAllocator     *allocator);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_pop_allocator is 
			-- Parsed as:
			-- void g_slist_pop_allocator (
			-- );
			--
			-- Original C code from glib.h:
			-- void    g_slist_pop_allocator   (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_alloc: POINTER is 
			-- Parsed as:
			-- GSList* g_slist_alloc (
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_alloc		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_free (a_list: POINTER) is 
			-- Parsed as:
			-- void g_slist_free (
			--     GSList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_slist_free		(GSList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_free_1 (a_list: POINTER) is 
			-- Parsed as:
			-- void g_slist_free_1 (
			--     GSList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_slist_free_1		(GSList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_append (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_append (
			--     GSList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_append		(GSList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_prepend (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_prepend (
			--     GSList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_prepend		(GSList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_insert (a_list: POINTER; a_data: POINTER; a_position: INTEGER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_insert (
			--     GSList *a_list,
			--     gpointer a_data,
			--     gint a_position
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_insert		(GSList		*list,
			-- 				 gpointer	 data,
			-- 				 gint		 position);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_insert_sorted (a_list: POINTER; a_data: POINTER; a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_insert_sorted (
			--     GSList *a_list,
			--     gpointer a_data,
			--     GCompareFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_insert_sorted	(GSList		*list,
			-- 				 gpointer	 data,
			-- 				 GCompareFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_concat (a_list1: POINTER; a_list2: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_concat (
			--     GSList *a_list1,
			--     GSList *a_list2
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_concat		(GSList		*list1,
			-- 				 GSList		*list2);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_remove (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_remove (
			--     GSList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_remove		(GSList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_remove_link (a_list: POINTER; a_llink: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_remove_link (
			--     GSList *a_list,
			--     GSList *a_llink
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_remove_link	(GSList		*list,
			-- 				 GSList		*llink);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_reverse (a_list: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_reverse (
			--     GSList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_reverse		(GSList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_copy (a_list: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_copy (
			--     GSList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- GSList*	g_slist_copy		(GSList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_nth (a_list: POINTER; a_n: INTEGER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_nth (
			--     GSList *a_list,
			--     guint a_n
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_nth		(GSList		*list,
			-- 				 guint		 n);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_find (a_list: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_find (
			--     GSList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_find		(GSList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_find_custom (a_list: POINTER; a_data: POINTER; a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_find_custom (
			--     GSList *a_list,
			--     gpointer a_data,
			--     GCompareFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_find_custom	(GSList		*list,
			-- 				 gpointer	 data,
			-- 				 GCompareFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_position (a_list: POINTER; a_llink: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_slist_position (
			--     GSList *a_list,
			--     GSList *a_llink
			-- );
			--
			-- Original C code from glib.h:
			-- gint	g_slist_position	(GSList		*list,
			-- 				 GSList		*llink);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_index (a_list: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_slist_index (
			--     GSList *a_list,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- gint	g_slist_index		(GSList		*list,
			-- 				 gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_last (a_list: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_last (
			--     GSList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- GSList* g_slist_last		(GSList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_length (a_list: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_slist_length (
			--     GSList *a_list
			-- );
			--
			-- Original C code from glib.h:
			-- guint	g_slist_length		(GSList		*list);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_foreach (a_list: POINTER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_slist_foreach (
			--     GSList *a_list,
			--     GFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_slist_foreach		(GSList		*list,
			-- 				 GFunc		 func,
			-- 				 gpointer	 user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_sort (a_list: POINTER; a_compare_func: POINTER): POINTER is 
			-- Parsed as:
			-- GSList* g_slist_sort (
			--     GSList *a_list,
			--     GCompareFunc a_compare_func
			-- );
			--
			-- Original C code from glib.h:
			-- GSList*  g_slist_sort           (GSList          *list,
			-- 		                 GCompareFunc    compare_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_slist_nth_data (a_list: POINTER; a_n: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_slist_nth_data (
			--     GSList *a_list,
			--     guint a_n
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_slist_nth_data	(GSList		*list,
			-- 				 guint		 n);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_new (a_hash_func: POINTER; a_key_compare_func: POINTER): POINTER is 
			-- Parsed as:
			-- GHashTable* g_hash_table_new (
			--     GHashFunc a_hash_func,
			--     GCompareFunc a_key_compare_func
			-- );
			--
			-- Original C code from glib.h:
			-- GHashTable* g_hash_table_new		(GHashFunc	 hash_func,
			-- 					 GCompareFunc	 key_compare_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_destroy (a_hash_table: POINTER) is 
			-- Parsed as:
			-- void g_hash_table_destroy (
			--     GHashTable *a_hash_table
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_hash_table_destroy	(GHashTable	*hash_table);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_insert (a_hash_table: POINTER; a_key: POINTER; a_value: POINTER) is 
			-- Parsed as:
			-- void g_hash_table_insert (
			--     GHashTable *a_hash_table,
			--     gpointer a_key,
			--     gpointer a_value
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_hash_table_insert		(GHashTable	*hash_table,
			-- 					 gpointer	 key,
			-- 					 gpointer	 value);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_remove (a_hash_table: POINTER; a_key: POINTER) is 
			-- Parsed as:
			-- void g_hash_table_remove (
			--     GHashTable *a_hash_table,
			--     gconstpointer a_key
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_hash_table_remove		(GHashTable	*hash_table,
			-- 					 gconstpointer	 key);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_lookup (a_hash_table: POINTER; a_key: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_hash_table_lookup (
			--     GHashTable *a_hash_table,
			--     gconstpointer a_key
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer    g_hash_table_lookup		(GHashTable	*hash_table,
			-- 					 gconstpointer	 key);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_lookup_extended (a_hash_table: POINTER; a_lookup_key: POINTER; a_orig_key: POINTER; a_value: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_hash_table_lookup_extended (
			--     GHashTable *a_hash_table,
			--     gconstpointer a_lookup_key,
			--     gpointer *a_orig_key,
			--     gpointer *a_value
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean    g_hash_table_lookup_extended(GHashTable	*hash_table,
			-- 					 gconstpointer	 lookup_key,
			-- 					 gpointer	*orig_key,
			-- 					 gpointer	*value);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_freeze (a_hash_table: POINTER) is 
			-- Parsed as:
			-- void g_hash_table_freeze (
			--     GHashTable *a_hash_table
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_hash_table_freeze		(GHashTable	*hash_table);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_thaw (a_hash_table: POINTER) is 
			-- Parsed as:
			-- void g_hash_table_thaw (
			--     GHashTable *a_hash_table
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_hash_table_thaw		(GHashTable	*hash_table);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_foreach (a_hash_table: POINTER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_hash_table_foreach (
			--     GHashTable *a_hash_table,
			--     GHFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_hash_table_foreach	(GHashTable	*hash_table,
			-- 					 GHFunc		 func,
			-- 					 gpointer	 user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_foreach_remove (a_hash_table: POINTER; a_func: POINTER; a_user_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_hash_table_foreach_remove (
			--     GHashTable *a_hash_table,
			--     GHRFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- guint	    g_hash_table_foreach_remove	(GHashTable	*hash_table,
			-- 					 GHRFunc	 func,
			-- 					 gpointer	 user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_hash_table_size (a_hash_table: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_hash_table_size (
			--     GHashTable *a_hash_table
			-- );
			--
			-- Original C code from glib.h:
			-- guint	    g_hash_table_size		(GHashTable	*hash_table);
		external
			" C | <gtk/gtk.h>"
		end

	g_cache_new (a_value_new_func: POINTER; a_value_destroy_func: POINTER; a_key_dup_func: POINTER; a_key_destroy_func: POINTER; a_hash_key_func: POINTER; a_hash_value_func: POINTER; a_key_compare_func: POINTER): POINTER is 
			-- Parsed as:
			-- GCache* g_cache_new (
			--     GCacheNewFunc a_value_new_func,
			--     GCacheDestroyFunc a_value_destroy_func,
			--     GCacheDupFunc a_key_dup_func,
			--     GCacheDestroyFunc a_key_destroy_func,
			--     GHashFunc a_hash_key_func,
			--     GHashFunc a_hash_value_func,
			--     GCompareFunc a_key_compare_func
			-- );
			--
			-- Original C code from glib.h:
			-- GCache*	 g_cache_new	       (GCacheNewFunc	   value_new_func,
			-- 				GCacheDestroyFunc  value_destroy_func,
			-- 				GCacheDupFunc	   key_dup_func,
			-- 				GCacheDestroyFunc  key_destroy_func,
			-- 				GHashFunc	   hash_key_func,
			-- 				GHashFunc	   hash_value_func,
			-- 				GCompareFunc	   key_compare_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_cache_destroy (a_cache: POINTER) is 
			-- Parsed as:
			-- void g_cache_destroy (
			--     GCache *a_cache
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_cache_destroy       (GCache		  *cache);
		external
			" C | <gtk/gtk.h>"
		end

	g_cache_insert (a_cache: POINTER; a_key: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_cache_insert (
			--     GCache *a_cache,
			--     gpointer a_key
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_cache_insert	       (GCache		  *cache,
			-- 				gpointer	   key);
		external
			" C | <gtk/gtk.h>"
		end

	g_cache_remove (a_cache: POINTER; a_value: POINTER) is 
			-- Parsed as:
			-- void g_cache_remove (
			--     GCache *a_cache,
			--     gpointer a_value
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_cache_remove	       (GCache		  *cache,
			-- 				gpointer	   value);
		external
			" C | <gtk/gtk.h>"
		end

	g_cache_key_foreach (a_cache: POINTER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_cache_key_foreach (
			--     GCache *a_cache,
			--     GHFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_cache_key_foreach   (GCache		  *cache,
			-- 				GHFunc		   func,
			-- 				gpointer	   user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_cache_value_foreach (a_cache: POINTER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_cache_value_foreach (
			--     GCache *a_cache,
			--     GHFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_cache_value_foreach (GCache		  *cache,
			-- 				GHFunc		   func,
			-- 				gpointer	   user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_new (a_key_compare_func: POINTER): POINTER is 
			-- Parsed as:
			-- GTree* g_tree_new (
			--     GCompareFunc a_key_compare_func
			-- );
			--
			-- Original C code from glib.h:
			-- GTree*	 g_tree_new	 (GCompareFunc	 key_compare_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_destroy (a_tree: POINTER) is 
			-- Parsed as:
			-- void g_tree_destroy (
			--     GTree *a_tree
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_tree_destroy	 (GTree		*tree);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_insert (a_tree: POINTER; a_key: POINTER; a_value: POINTER) is 
			-- Parsed as:
			-- void g_tree_insert (
			--     GTree *a_tree,
			--     gpointer a_key,
			--     gpointer a_value
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_tree_insert	 (GTree		*tree,
			-- 			  gpointer	 key,
			-- 			  gpointer	 value);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_remove (a_tree: POINTER; a_key: POINTER) is 
			-- Parsed as:
			-- void g_tree_remove (
			--     GTree *a_tree,
			--     gpointer a_key
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_tree_remove	 (GTree		*tree,
			-- 			  gpointer	 key);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_lookup (a_tree: POINTER; a_key: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_tree_lookup (
			--     GTree *a_tree,
			--     gpointer a_key
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_tree_lookup	 (GTree		*tree,
			-- 			  gpointer	 key);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_traverse (a_tree: POINTER; a_traverse_func: POINTER; a_traverse_type: INTEGER; a_data: POINTER) is 
			-- Parsed as:
			-- void g_tree_traverse (
			--     GTree *a_tree,
			--     GTraverseFunc a_traverse_func,
			--     GTraverseType a_traverse_type,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_tree_traverse (GTree		*tree,
			-- 			  GTraverseFunc	 traverse_func,
			-- 			  GTraverseType	 traverse_type,
			-- 			  gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_search (a_tree: POINTER; a_search_func: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_tree_search (
			--     GTree *a_tree,
			--     GSearchFunc a_search_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_tree_search	 (GTree		*tree,
			-- 			  GSearchFunc	 search_func,
			-- 			  gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_height (a_tree: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_tree_height (
			--     GTree *a_tree
			-- );
			--
			-- Original C code from glib.h:
			-- gint	 g_tree_height	 (GTree		*tree);
		external
			" C | <gtk/gtk.h>"
		end

	g_tree_nnodes (a_tree: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_tree_nnodes (
			--     GTree *a_tree
			-- );
			--
			-- Original C code from glib.h:
			-- gint	 g_tree_nnodes	 (GTree		*tree);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_push_allocator (a_allocator: POINTER) is 
			-- Parsed as:
			-- void g_node_push_allocator (
			--     GAllocator *a_allocator
			-- );
			--
			-- Original C code from glib.h:
			-- void     g_node_push_allocator  (GAllocator       *allocator);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_pop_allocator is 
			-- Parsed as:
			-- void g_node_pop_allocator (
			-- );
			--
			-- Original C code from glib.h:
			-- void     g_node_pop_allocator   (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_new (a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_new (
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_new		(gpointer	   data);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_destroy (a_root: POINTER) is 
			-- Parsed as:
			-- void g_node_destroy (
			--     GNode *a_root
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_node_destroy		(GNode		  *root);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_unlink (a_node: POINTER) is 
			-- Parsed as:
			-- void g_node_unlink (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_node_unlink		(GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_insert (a_parent: POINTER; a_position: INTEGER; a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_insert (
			--     GNode *a_parent,
			--     gint a_position,
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_insert		(GNode		  *parent,
			-- 				 gint		   position,
			-- 				 GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_insert_before (a_parent: POINTER; a_sibling: POINTER; a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_insert_before (
			--     GNode *a_parent,
			--     GNode *a_sibling,
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_insert_before	(GNode		  *parent,
			-- 				 GNode		  *sibling,
			-- 				 GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_prepend (a_parent: POINTER; a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_prepend (
			--     GNode *a_parent,
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_prepend		(GNode		  *parent,
			-- 				 GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_n_nodes (a_root: POINTER; a_flags: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint g_node_n_nodes (
			--     GNode *a_root,
			--     GTraverseFlags a_flags
			-- );
			--
			-- Original C code from glib.h:
			-- guint	 g_node_n_nodes		(GNode		  *root,
			-- 				 GTraverseFlags	   flags);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_get_root (a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_get_root (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_get_root	(GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_is_ancestor (a_node: POINTER; a_descendant: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_node_is_ancestor (
			--     GNode *a_node,
			--     GNode *a_descendant
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean g_node_is_ancestor	(GNode		  *node,
			-- 				 GNode		  *descendant);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_depth (a_node: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_node_depth (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- guint	 g_node_depth		(GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_find (a_root: POINTER; a_order: INTEGER; a_flags: INTEGER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_find (
			--     GNode *a_root,
			--     GTraverseType a_order,
			--     GTraverseFlags a_flags,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_find		(GNode		  *root,
			-- 				 GTraverseType	   order,
			-- 				 GTraverseFlags	   flags,
			-- 				 gpointer	   data);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_traverse (a_root: POINTER; a_order: INTEGER; a_flags: INTEGER; a_max_depth: INTEGER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void g_node_traverse (
			--     GNode *a_root,
			--     GTraverseType a_order,
			--     GTraverseFlags a_flags,
			--     gint a_max_depth,
			--     GNodeTraverseFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_node_traverse	(GNode		  *root,
			-- 				 GTraverseType	   order,
			-- 				 GTraverseFlags	   flags,
			-- 				 gint		   max_depth,
			-- 				 GNodeTraverseFunc func,
			-- 				 gpointer	   data);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_max_height (a_root: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_node_max_height (
			--     GNode *a_root
			-- );
			--
			-- Original C code from glib.h:
			-- guint	 g_node_max_height	 (GNode *root);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_children_foreach (a_node: POINTER; a_flags: INTEGER; a_func: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void g_node_children_foreach (
			--     GNode *a_node,
			--     GTraverseFlags a_flags,
			--     GNodeForeachFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_node_children_foreach (GNode		  *node,
			-- 				  GTraverseFlags   flags,
			-- 				  GNodeForeachFunc func,
			-- 				  gpointer	   data);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_reverse_children (a_node: POINTER) is 
			-- Parsed as:
			-- void g_node_reverse_children (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_node_reverse_children (GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_n_children (a_node: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_node_n_children (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- guint	 g_node_n_children	 (GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_nth_child (a_node: POINTER; a_n: INTEGER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_nth_child (
			--     GNode *a_node,
			--     guint a_n
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_nth_child	 (GNode		  *node,
			-- 				  guint		   n);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_last_child (a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_last_child (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_last_child	 (GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_find_child (a_node: POINTER; a_flags: INTEGER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_find_child (
			--     GNode *a_node,
			--     GTraverseFlags a_flags,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_find_child	 (GNode		  *node,
			-- 				  GTraverseFlags   flags,
			-- 				  gpointer	   data);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_child_position (a_node: POINTER; a_child: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_node_child_position (
			--     GNode *a_node,
			--     GNode *a_child
			-- );
			--
			-- Original C code from glib.h:
			-- gint	 g_node_child_position	 (GNode		  *node,
			-- 				  GNode		  *child);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_child_index (a_node: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_node_child_index (
			--     GNode *a_node,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- gint	 g_node_child_index	 (GNode		  *node,
			-- 				  gpointer	   data);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_first_sibling (a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_first_sibling (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_first_sibling	 (GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_node_last_sibling (a_node: POINTER): POINTER is 
			-- Parsed as:
			-- GNode* g_node_last_sibling (
			--     GNode *a_node
			-- );
			--
			-- Original C code from glib.h:
			-- GNode*	 g_node_last_sibling	 (GNode		  *node);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_list_init (a_hook_list: POINTER; a_hook_size: INTEGER) is 
			-- Parsed as:
			-- void g_hook_list_init (
			--     GHookList *a_hook_list,
			--     guint a_hook_size
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_list_init		(GHookList		*hook_list,
			-- 					 guint			 hook_size);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_list_clear (a_hook_list: POINTER) is 
			-- Parsed as:
			-- void g_hook_list_clear (
			--     GHookList *a_hook_list
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_list_clear		(GHookList		*hook_list);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_alloc (a_hook_list: POINTER): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_alloc (
			--     GHookList *a_hook_list
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_alloc			(GHookList		*hook_list);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_free (a_hook_list: POINTER; a_hook: POINTER) is 
			-- Parsed as:
			-- void g_hook_free (
			--     GHookList *a_hook_list,
			--     GHook *a_hook
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_free			(GHookList		*hook_list,
			-- 					 GHook			*hook);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_ref (a_hook_list: POINTER; a_hook: POINTER) is 
			-- Parsed as:
			-- void g_hook_ref (
			--     GHookList *a_hook_list,
			--     GHook *a_hook
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_ref			(GHookList		*hook_list,
			-- 					 GHook			*hook);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_unref (a_hook_list: POINTER; a_hook: POINTER) is 
			-- Parsed as:
			-- void g_hook_unref (
			--     GHookList *a_hook_list,
			--     GHook *a_hook
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_unref			(GHookList		*hook_list,
			-- 					 GHook			*hook);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_destroy (a_hook_list: POINTER; a_hook_id: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_hook_destroy (
			--     GHookList *a_hook_list,
			--     guint a_hook_id
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean g_hook_destroy			(GHookList		*hook_list,
			-- 					 guint			 hook_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_destroy_link (a_hook_list: POINTER; a_hook: POINTER) is 
			-- Parsed as:
			-- void g_hook_destroy_link (
			--     GHookList *a_hook_list,
			--     GHook *a_hook
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_destroy_link		(GHookList		*hook_list,
			-- 					 GHook			*hook);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_prepend (a_hook_list: POINTER; a_hook: POINTER) is 
			-- Parsed as:
			-- void g_hook_prepend (
			--     GHookList *a_hook_list,
			--     GHook *a_hook
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_prepend			(GHookList		*hook_list,
			-- 					 GHook			*hook);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_insert_before (a_hook_list: POINTER; a_sibling: POINTER; a_hook: POINTER) is 
			-- Parsed as:
			-- void g_hook_insert_before (
			--     GHookList *a_hook_list,
			--     GHook *a_sibling,
			--     GHook *a_hook
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_insert_before		(GHookList		*hook_list,
			-- 					 GHook			*sibling,
			-- 					 GHook			*hook);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_insert_sorted (a_hook_list: POINTER; a_hook: POINTER; a_func: POINTER) is 
			-- Parsed as:
			-- void g_hook_insert_sorted (
			--     GHookList *a_hook_list,
			--     GHook *a_hook,
			--     GHookCompareFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_insert_sorted		(GHookList		*hook_list,
			-- 					 GHook			*hook,
			-- 					 GHookCompareFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_get (a_hook_list: POINTER; a_hook_id: INTEGER): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_get (
			--     GHookList *a_hook_list,
			--     guint a_hook_id
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_get			(GHookList		*hook_list,
			-- 					 guint			 hook_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_find (a_hook_list: POINTER; a_need_valids: BOOLEAN; a_func: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_find (
			--     GHookList *a_hook_list,
			--     gboolean a_need_valids,
			--     GHookFindFunc a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_find			(GHookList		*hook_list,
			-- 					 gboolean		 need_valids,
			-- 					 GHookFindFunc		 func,
			-- 					 gpointer		 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_find_data (a_hook_list: POINTER; a_need_valids: BOOLEAN; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_find_data (
			--     GHookList *a_hook_list,
			--     gboolean a_need_valids,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_find_data		(GHookList		*hook_list,
			-- 					 gboolean		 need_valids,
			-- 					 gpointer		 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_find_func (a_hook_list: POINTER; a_need_valids: BOOLEAN; a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_find_func (
			--     GHookList *a_hook_list,
			--     gboolean a_need_valids,
			--     gpointer a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_find_func		(GHookList		*hook_list,
			-- 					 gboolean		 need_valids,
			-- 					 gpointer		 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_find_func_data (a_hook_list: POINTER; a_need_valids: BOOLEAN; a_func: POINTER; a_data: POINTER): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_find_func_data (
			--     GHookList *a_hook_list,
			--     gboolean a_need_valids,
			--     gpointer a_func,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_find_func_data		(GHookList		*hook_list,
			-- 					 gboolean		 need_valids,
			-- 					 gpointer		 func,
			-- 					 gpointer		 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_first_valid (a_hook_list: POINTER; a_may_be_in_call: BOOLEAN): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_first_valid (
			--     GHookList *a_hook_list,
			--     gboolean a_may_be_in_call
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_first_valid		(GHookList		*hook_list,
			-- 					 gboolean		 may_be_in_call);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_next_valid (a_hook_list: POINTER; a_hook: POINTER; a_may_be_in_call: BOOLEAN): POINTER is 
			-- Parsed as:
			-- GHook* g_hook_next_valid (
			--     GHookList *a_hook_list,
			--     GHook *a_hook,
			--     gboolean a_may_be_in_call
			-- );
			--
			-- Original C code from glib.h:
			-- GHook*	 g_hook_next_valid		(GHookList		*hook_list,
			-- 					 GHook			*hook,
			-- 					 gboolean		 may_be_in_call);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_compare_ids (a_new_hook: POINTER; a_sibling: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_hook_compare_ids (
			--     GHook *a_new_hook,
			--     GHook *a_sibling
			-- );
			--
			-- Original C code from glib.h:
			-- gint	 g_hook_compare_ids		(GHook			*new_hook,
			-- 					 GHook			*sibling);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_list_invoke (a_hook_list: POINTER; a_may_recurse: BOOLEAN) is 
			-- Parsed as:
			-- void g_hook_list_invoke (
			--     GHookList *a_hook_list,
			--     gboolean a_may_recurse
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_list_invoke		(GHookList		*hook_list,
			-- 					 gboolean		 may_recurse);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_list_invoke_check (a_hook_list: POINTER; a_may_recurse: BOOLEAN) is 
			-- Parsed as:
			-- void g_hook_list_invoke_check (
			--     GHookList *a_hook_list,
			--     gboolean a_may_recurse
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_list_invoke_check	(GHookList		*hook_list,
			-- 					 gboolean		 may_recurse);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_list_marshal (a_hook_list: POINTER; a_may_recurse: BOOLEAN; a_marshaller: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void g_hook_list_marshal (
			--     GHookList *a_hook_list,
			--     gboolean a_may_recurse,
			--     GHookMarshaller a_marshaller,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_list_marshal		(GHookList		*hook_list,
			-- 					 gboolean		 may_recurse,
			-- 					 GHookMarshaller	 marshaller,
			-- 					 gpointer		 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_hook_list_marshal_check (a_hook_list: POINTER; a_may_recurse: BOOLEAN; a_marshaller: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void g_hook_list_marshal_check (
			--     GHookList *a_hook_list,
			--     gboolean a_may_recurse,
			--     GHookCheckMarshaller a_marshaller,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_hook_list_marshal_check	(GHookList		*hook_list,
			-- 					 gboolean		 may_recurse,
			-- 					 GHookCheckMarshaller	 marshaller,
			-- 					 gpointer		 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_on_error_query (a_prg_name: POINTER) is 
			-- Parsed as:
			-- void g_on_error_query (
			--     gchar *a_prg_name
			-- );
			--
			-- Original C code from glib.h:
			-- void g_on_error_query (const gchar *prg_name);
		external
			" C | <gtk/gtk.h>"
		end

	g_on_error_stack_trace (a_prg_name: POINTER) is 
			-- Parsed as:
			-- void g_on_error_stack_trace (
			--     gchar *a_prg_name
			-- );
			--
			-- Original C code from glib.h:
			-- void g_on_error_stack_trace (const gchar *prg_name);
		external
			" C | <gtk/gtk.h>"
		end

	g_log_set_handler (a_log_domain: POINTER; a_log_levels: INTEGER; a_log_func: POINTER; a_user_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_log_set_handler (
			--     gchar *a_log_domain,
			--     GLogLevelFlags a_log_levels,
			--     GLogFunc a_log_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- guint		g_log_set_handler	(const gchar	*log_domain,
			-- 					 GLogLevelFlags	 log_levels,
			-- 					 GLogFunc	 log_func,
			-- 					 gpointer	 user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_log_remove_handler (a_log_domain: POINTER; a_handler_id: INTEGER) is 
			-- Parsed as:
			-- void g_log_remove_handler (
			--     gchar *a_log_domain,
			--     guint a_handler_id
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_log_remove_handler	(const gchar	*log_domain,
			-- 					 guint		 handler_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_log_default_handler (a_log_domain: POINTER; a_log_level: INTEGER; a_message: POINTER; a_unused_data: POINTER) is 
			-- Parsed as:
			-- void g_log_default_handler (
			--     gchar *a_log_domain,
			--     GLogLevelFlags a_log_level,
			--     gchar *a_message,
			--     gpointer a_unused_data
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_log_default_handler	(const gchar	*log_domain,
			-- 					 GLogLevelFlags	 log_level,
			-- 					 const gchar	*message,
			-- 					 gpointer	 unused_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_logv (a_log_domain: POINTER; a_log_level: INTEGER; a_format: POINTER; a_args: POINTER) is 
			-- Parsed as:
			-- void g_logv (
			--     gchar *a_log_domain,
			--     GLogLevelFlags a_log_level,
			--     gchar *a_format,
			--     va_list a_args
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_logv			(const gchar	*log_domain,
			-- 					 GLogLevelFlags	 log_level,
			-- 					 const gchar	*format,
			-- 					 va_list	 args);
		external
			" C | <gtk/gtk.h>"
		end

	g_log_set_fatal_mask (a_log_domain: POINTER; a_fatal_mask: INTEGER): INTEGER is 
			-- Parsed as:
			-- GLogLevelFlags g_log_set_fatal_mask (
			--     gchar *a_log_domain,
			--     GLogLevelFlags a_fatal_mask
			-- );
			--
			-- Original C code from glib.h:
			-- GLogLevelFlags	g_log_set_fatal_mask	(const gchar	*log_domain,
			-- 					 GLogLevelFlags	 fatal_mask);
		external
			" C | <gtk/gtk.h>"
		end

	g_log_set_always_fatal (a_fatal_mask: INTEGER): INTEGER is 
			-- Parsed as:
			-- GLogLevelFlags g_log_set_always_fatal (
			--     GLogLevelFlags a_fatal_mask
			-- );
			--
			-- Original C code from glib.h:
			-- GLogLevelFlags	g_log_set_always_fatal	(GLogLevelFlags	 fatal_mask);
		external
			" C | <gtk/gtk.h>"
		end

	g_set_print_handler (a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GPrintFunc g_set_print_handler (
			--     GPrintFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GPrintFunc	g_set_print_handler	(GPrintFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_set_printerr_handler (a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GPrintFunc g_set_printerr_handler (
			--     GPrintFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GPrintFunc	g_set_printerr_handler	(GPrintFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_set_error_handler (a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GErrorFunc g_set_error_handler (
			--     GErrorFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GErrorFunc   g_set_error_handler   (GErrorFunc	 func);
		external
			" C | <gtk/gtk.h>"
		end

	g_set_warning_handler (a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GWarningFunc g_set_warning_handler (
			--     GWarningFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GWarningFunc g_set_warning_handler (GWarningFunc func);
		external
			" C | <gtk/gtk.h>"
		end

	g_set_message_handler (a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GPrintFunc g_set_message_handler (
			--     GPrintFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GPrintFunc   g_set_message_handler (GPrintFunc func);
		external
			" C | <gtk/gtk.h>"
		end

	g_malloc (a_size: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_malloc (
			--     gulong a_size
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_malloc      (gulong	  size);
		external
			" C | <gtk/gtk.h>"
		end

	g_malloc0 (a_size: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_malloc0 (
			--     gulong a_size
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_malloc0     (gulong	  size);
		external
			" C | <gtk/gtk.h>"
		end

	g_realloc (a_mem: POINTER; a_size: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_realloc (
			--     gpointer a_mem,
			--     gulong a_size
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_realloc     (gpointer  mem,
			-- 			gulong	  size);
		external
			" C | <gtk/gtk.h>"
		end

	g_free (a_mem: POINTER) is 
			-- Parsed as:
			-- void g_free (
			--     gpointer a_mem
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_free	       (gpointer  mem);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_profile is 
			-- Parsed as:
			-- void g_mem_profile (
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_mem_profile (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_check (a_mem: POINTER) is 
			-- Parsed as:
			-- void g_mem_check (
			--     gpointer a_mem
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_mem_check   (gpointer  mem);
		external
			" C | <gtk/gtk.h>"
		end

	g_allocator_new (a_name: POINTER; a_n_preallocs: INTEGER): POINTER is 
			-- Parsed as:
			-- GAllocator* g_allocator_new (
			--     gchar *a_name,
			--     guint a_n_preallocs
			-- );
			--
			-- Original C code from glib.h:
			-- GAllocator* g_allocator_new   (const gchar  *name,
			-- 			       guint         n_preallocs);
		external
			" C | <gtk/gtk.h>"
		end

	g_allocator_free (a_allocator: POINTER) is 
			-- Parsed as:
			-- void g_allocator_free (
			--     GAllocator *a_allocator
			-- );
			--
			-- Original C code from glib.h:
			-- void        g_allocator_free  (GAllocator   *allocator);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_new (a_name: POINTER; a_atom_size: INTEGER; a_area_size: INTEGER; a_type: INTEGER): POINTER is 
			-- Parsed as:
			-- GMemChunk* g_mem_chunk_new (
			--     gchar *a_name,
			--     gint a_atom_size,
			--     gulong a_area_size,
			--     gint a_type
			-- );
			--
			-- Original C code from glib.h:
			-- GMemChunk* g_mem_chunk_new     (gchar	  *name,
			-- 				gint	   atom_size,
			-- 				gulong	   area_size,
			-- 				gint	   type);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_destroy (a_mem_chunk: POINTER) is 
			-- Parsed as:
			-- void g_mem_chunk_destroy (
			--     GMemChunk *a_mem_chunk
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_mem_chunk_destroy (GMemChunk *mem_chunk);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_alloc (a_mem_chunk: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_mem_chunk_alloc (
			--     GMemChunk *a_mem_chunk
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer   g_mem_chunk_alloc   (GMemChunk *mem_chunk);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_alloc0 (a_mem_chunk: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_mem_chunk_alloc0 (
			--     GMemChunk *a_mem_chunk
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer   g_mem_chunk_alloc0  (GMemChunk *mem_chunk);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_free (a_mem_chunk: POINTER; a_mem: POINTER) is 
			-- Parsed as:
			-- void g_mem_chunk_free (
			--     GMemChunk *a_mem_chunk,
			--     gpointer a_mem
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_mem_chunk_free    (GMemChunk *mem_chunk,
			-- 				gpointer   mem);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_clean (a_mem_chunk: POINTER) is 
			-- Parsed as:
			-- void g_mem_chunk_clean (
			--     GMemChunk *a_mem_chunk
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_mem_chunk_clean   (GMemChunk *mem_chunk);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_reset (a_mem_chunk: POINTER) is 
			-- Parsed as:
			-- void g_mem_chunk_reset (
			--     GMemChunk *a_mem_chunk
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_mem_chunk_reset   (GMemChunk *mem_chunk);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_print (a_mem_chunk: POINTER) is 
			-- Parsed as:
			-- void g_mem_chunk_print (
			--     GMemChunk *a_mem_chunk
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_mem_chunk_print   (GMemChunk *mem_chunk);
		external
			" C | <gtk/gtk.h>"
		end

	g_mem_chunk_info is 
			-- Parsed as:
			-- void g_mem_chunk_info (
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_mem_chunk_info    (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_blow_chunks is 
			-- Parsed as:
			-- void g_blow_chunks (
			-- );
			--
			-- Original C code from glib.h:
			-- void g_blow_chunks (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_timer_new: POINTER is 
			-- Parsed as:
			-- GTimer* g_timer_new (
			-- );
			--
			-- Original C code from glib.h:
			-- GTimer* g_timer_new	(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_timer_destroy (a_timer: POINTER) is 
			-- Parsed as:
			-- void g_timer_destroy (
			--     GTimer *a_timer
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_timer_destroy (GTimer	 *timer);
		external
			" C | <gtk/gtk.h>"
		end

	g_timer_start (a_timer: POINTER) is 
			-- Parsed as:
			-- void g_timer_start (
			--     GTimer *a_timer
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_timer_start	(GTimer	 *timer);
		external
			" C | <gtk/gtk.h>"
		end

	g_timer_stop (a_timer: POINTER) is 
			-- Parsed as:
			-- void g_timer_stop (
			--     GTimer *a_timer
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_timer_stop	(GTimer	 *timer);
		external
			" C | <gtk/gtk.h>"
		end

	g_timer_reset (a_timer: POINTER) is 
			-- Parsed as:
			-- void g_timer_reset (
			--     GTimer *a_timer
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_timer_reset	(GTimer	 *timer);
		external
			" C | <gtk/gtk.h>"
		end

	g_timer_elapsed (a_timer: POINTER; a_microseconds: POINTER): DOUBLE is 
			-- Parsed as:
			-- gdouble g_timer_elapsed (
			--     GTimer *a_timer,
			--     gulong *a_microseconds
			-- );
			--
			-- Original C code from glib.h:
			-- gdouble g_timer_elapsed (GTimer	 *timer,
			-- 			 gulong	 *microseconds);
		external
			" C | <gtk/gtk.h>"
		end

	g_strdelimit (a_string: POINTER; a_delimiters: POINTER; a_new_delimiter: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* g_strdelimit (
			--     gchar *a_string,
			--     gchar *a_delimiters,
			--     gchar a_new_delimiter
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strdelimit		(gchar	     *string,
			-- 				 const gchar *delimiters,
			-- 				 gchar	      new_delimiter);
		external
			" C | <gtk/gtk.h>"
		end

	g_strtod (a_nptr: POINTER; a_endptr: POINTER): DOUBLE is 
			-- Parsed as:
			-- gdouble g_strtod (
			--     gchar *a_nptr,
			--     gchar **a_endptr
			-- );
			--
			-- Original C code from glib.h:
			-- gdouble	 g_strtod		(const gchar *nptr,
			-- 				 gchar	    **endptr);
		external
			" C | <gtk/gtk.h>"
		end

	g_strerror (a_errnum: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* g_strerror (
			--     gint a_errnum
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strerror		(gint	      errnum);
		external
			" C | <gtk/gtk.h>"
		end

	g_strsignal (a_signum: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* g_strsignal (
			--     gint a_signum
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strsignal		(gint	      signum);
		external
			" C | <gtk/gtk.h>"
		end

	g_strcasecmp (a_s1: POINTER; a_s2: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_strcasecmp (
			--     gchar *a_s1,
			--     gchar *a_s2
			-- );
			--
			-- Original C code from glib.h:
			-- gint	 g_strcasecmp		(const gchar *s1,
			-- 				 const gchar *s2);
		external
			" C | <gtk/gtk.h>"
		end

	g_strncasecmp (a_s1: POINTER; a_s2: POINTER; a_n: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint g_strncasecmp (
			--     gchar *a_s1,
			--     gchar *a_s2,
			--     guint a_n
			-- );
			--
			-- Original C code from glib.h:
			-- gint	 g_strncasecmp		(const gchar *s1,
			-- 				 const gchar *s2,
			-- 				 guint 	      n);
		external
			" C | <gtk/gtk.h>"
		end

	g_strdown (a_string: POINTER) is 
			-- Parsed as:
			-- void g_strdown (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_strdown		(gchar	     *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_strup (a_string: POINTER) is 
			-- Parsed as:
			-- void g_strup (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_strup		(gchar	     *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_strreverse (a_string: POINTER) is 
			-- Parsed as:
			-- void g_strreverse (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_strreverse		(gchar	     *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_strchug (a_string: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_strchug (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*   g_strchug              (gchar        *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_strchomp (a_string: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_strchomp (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*  g_strchomp              (gchar        *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_strdup (a_str: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_strdup (
			--     gchar *a_str
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strdup		(const gchar *str);
		external
			" C | <gtk/gtk.h>"
		end

	g_strdup_vprintf (a_format: POINTER; a_args: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_strdup_vprintf (
			--     gchar *a_format,
			--     va_list a_args
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strdup_vprintf	(const gchar *format,
			-- 				 va_list      args);
		external
			" C | <gtk/gtk.h>"
		end

	g_strndup (a_str: POINTER; a_n: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* g_strndup (
			--     gchar *a_str,
			--     guint a_n
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strndup		(const gchar *str,
			-- 				 guint	      n);
		external
			" C | <gtk/gtk.h>"
		end

	g_strnfill (a_length: INTEGER; a_fill_char: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* g_strnfill (
			--     guint a_length,
			--     gchar a_fill_char
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strnfill		(guint	      length,
			-- 				 gchar	      fill_char);
		external
			" C | <gtk/gtk.h>"
		end

	g_strescape (a_string: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_strescape (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	 g_strescape		(gchar	      *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_memdup (a_mem: POINTER; a_byte_size: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_memdup (
			--     gconstpointer a_mem,
			--     guint a_byte_size
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_memdup		(gconstpointer mem,
			-- 				 guint	       byte_size);
		external
			" C | <gtk/gtk.h>"
		end

	g_strsplit (a_string: POINTER; a_delimiter: POINTER; a_max_tokens: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar** g_strsplit (
			--     gchar *a_string,
			--     gchar *a_delimiter,
			--     gint a_max_tokens
			-- );
			--
			-- Original C code from glib.h:
			-- gchar**	 g_strsplit		(const gchar  *string,
			-- 				 const gchar  *delimiter,
			-- 				 gint          max_tokens);
		external
			" C | <gtk/gtk.h>"
		end

	g_strjoinv (a_separator: POINTER; a_str_array: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_strjoinv (
			--     gchar *a_separator,
			--     gchar **a_str_array
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*   g_strjoinv		(const gchar  *separator,
			-- 				 gchar       **str_array);
		external
			" C | <gtk/gtk.h>"
		end

	g_strfreev (a_str_array: POINTER) is 
			-- Parsed as:
			-- void g_strfreev (
			--     gchar **a_str_array
			-- );
			--
			-- Original C code from glib.h:
			-- void     g_strfreev		(gchar       **str_array);
		external
			" C | <gtk/gtk.h>"
		end

	g_printf_string_upper_bound (a_format: POINTER; a_args: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_printf_string_upper_bound (
			--     gchar *a_format,
			--     va_list a_args
			-- );
			--
			-- Original C code from glib.h:
			-- guint	g_printf_string_upper_bound (const gchar* format,
			-- 				     va_list	  args);
		external
			" C | <gtk/gtk.h>"
		end

	g_get_user_name: POINTER is 
			-- Parsed as:
			-- gchar* g_get_user_name (
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_get_user_name		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_get_real_name: POINTER is 
			-- Parsed as:
			-- gchar* g_get_real_name (
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_get_real_name		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_get_home_dir: POINTER is 
			-- Parsed as:
			-- gchar* g_get_home_dir (
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_get_home_dir		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_get_tmp_dir: POINTER is 
			-- Parsed as:
			-- gchar* g_get_tmp_dir (
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_get_tmp_dir		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_get_prgname: POINTER is 
			-- Parsed as:
			-- gchar* g_get_prgname (
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_get_prgname		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_set_prgname (a_prgname: POINTER) is 
			-- Parsed as:
			-- void g_set_prgname (
			--     gchar *a_prgname
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_set_prgname		(const gchar *prgname);
		external
			" C | <gtk/gtk.h>"
		end

	g_parse_debug_string (a_string: POINTER; a_keys: POINTER; a_nkeys: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint g_parse_debug_string (
			--     gchar *a_string,
			--     GDebugKey *a_keys,
			--     guint a_nkeys
			-- );
			--
			-- Original C code from glib.h:
			-- guint	g_parse_debug_string	(const gchar *string,
			-- 				 GDebugKey   *keys,
			-- 				 guint	      nkeys);
		external
			" C | <gtk/gtk.h>"
		end

	g_vsnprintf (a_string: POINTER; a_n: INTEGER; a_format: POINTER; a_args: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_vsnprintf (
			--     gchar *a_string,
			--     gulong a_n,
			--     const *a_format,
			--     va_list a_args
			-- );
			--
			-- Original C code from glib.h:
			-- gint	g_vsnprintf		(gchar	     *string,
			-- 				 gulong	      n,
			-- 				 gchar const *format,
			-- 				 va_list      args);
		external
			" C | <gtk/gtk.h>"
		end

	g_basename (a_file_name: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_basename (
			--     gchar *a_file_name
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_basename		(const gchar *file_name);
		external
			" C | <gtk/gtk.h>"
		end

	g_path_is_absolute (a_file_name: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_path_is_absolute (
			--     gchar *a_file_name
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean g_path_is_absolute	(const gchar *file_name);
		external
			" C | <gtk/gtk.h>"
		end

	g_path_skip_root (a_file_name: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_path_skip_root (
			--     gchar *a_file_name
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*  g_path_skip_root	(gchar       *file_name);
		external
			" C | <gtk/gtk.h>"
		end

	g_dirname (a_file_name: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_dirname (
			--     gchar *a_file_name
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_dirname		(const gchar *file_name);
		external
			" C | <gtk/gtk.h>"
		end

	g_get_current_dir: POINTER is 
			-- Parsed as:
			-- gchar* g_get_current_dir (
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	g_get_current_dir	(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_getenv (a_variable: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_getenv (
			--     gchar *a_variable
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*  g_getenv		(const gchar *variable);
		external
			" C | <gtk/gtk.h>"
		end

	g_atexit (a_func: POINTER) is 
			-- Parsed as:
			-- void g_atexit (
			--     GVoidFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_atexit		(GVoidFunc    func);
		external
			" C | <gtk/gtk.h>"
		end

	g_bit_nth_lsf (a_mask: INTEGER; a_nth_bit: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint g_bit_nth_lsf (
			--     guint32 a_mask,
			--     gint a_nth_bit
			-- );
			--
			-- Original C code from glib.h:
			-- extern  gint	g_bit_nth_lsf (guint32 mask,
			-- 				       gint    nth_bit);
		external
			" C | <gtk/gtk.h>"
		end

	g_bit_nth_msf (a_mask: INTEGER; a_nth_bit: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint g_bit_nth_msf (
			--     guint32 a_mask,
			--     gint a_nth_bit
			-- );
			--
			-- Original C code from glib.h:
			-- extern  gint	g_bit_nth_msf (guint32 mask,
			-- 				       gint    nth_bit);
		external
			" C | <gtk/gtk.h>"
		end

	g_bit_storage (a_number: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint g_bit_storage (
			--     guint a_number
			-- );
			--
			-- Original C code from glib.h:
			-- extern  guint	g_bit_storage (guint number);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_chunk_new (a_size: INTEGER): POINTER is 
			-- Parsed as:
			-- GStringChunk* g_string_chunk_new (
			--     gint a_size
			-- );
			--
			-- Original C code from glib.h:
			-- GStringChunk* g_string_chunk_new	   (gint size);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_chunk_free (a_chunk: POINTER) is 
			-- Parsed as:
			-- void g_string_chunk_free (
			--     GStringChunk *a_chunk
			-- );
			--
			-- Original C code from glib.h:
			-- void	      g_string_chunk_free	   (GStringChunk *chunk);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_chunk_insert (a_chunk: POINTER; a_string: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_string_chunk_insert (
			--     GStringChunk *a_chunk,
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	      g_string_chunk_insert	   (GStringChunk *chunk,
			-- 					    const gchar	 *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_chunk_insert_const (a_chunk: POINTER; a_string: POINTER): POINTER is 
			-- Parsed as:
			-- gchar* g_string_chunk_insert_const (
			--     GStringChunk *a_chunk,
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	      g_string_chunk_insert_const  (GStringChunk *chunk,
			-- 					    const gchar	 *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_new (a_init: POINTER): POINTER is 
			-- Parsed as:
			-- GString* g_string_new (
			--     gchar *a_init
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_new	    (const gchar *init);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_sized_new (a_dfl_size: INTEGER): POINTER is 
			-- Parsed as:
			-- GString* g_string_sized_new (
			--     guint a_dfl_size
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_sized_new (guint	  dfl_size);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_free (a_string: POINTER; a_free_segment: INTEGER) is 
			-- Parsed as:
			-- void g_string_free (
			--     GString *a_string,
			--     gint a_free_segment
			-- );
			--
			-- Original C code from glib.h:
			-- void	 g_string_free	    (GString	 *string,
			-- 			     gint	  free_segment);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_assign (a_lval: POINTER; a_rval: POINTER): POINTER is 
			-- Parsed as:
			-- GString* g_string_assign (
			--     GString *a_lval,
			--     gchar *a_rval
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_assign    (GString	 *lval,
			-- 			     const gchar *rval);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_truncate (a_string: POINTER; a_len: INTEGER): POINTER is 
			-- Parsed as:
			-- GString* g_string_truncate (
			--     GString *a_string,
			--     gint a_len
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_truncate  (GString	 *string,
			-- 			     gint	  len);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_append (a_string: POINTER; a_val: POINTER): POINTER is 
			-- Parsed as:
			-- GString* g_string_append (
			--     GString *a_string,
			--     gchar *a_val
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_append    (GString	 *string,
			-- 			     const gchar *val);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_append_c (a_string: POINTER; a_c: INTEGER): POINTER is 
			-- Parsed as:
			-- GString* g_string_append_c (
			--     GString *a_string,
			--     gchar a_c
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_append_c  (GString	 *string,
			-- 			     gchar	  c);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_prepend (a_string: POINTER; a_val: POINTER): POINTER is 
			-- Parsed as:
			-- GString* g_string_prepend (
			--     GString *a_string,
			--     gchar *a_val
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_prepend   (GString	 *string,
			-- 			     const gchar *val);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_prepend_c (a_string: POINTER; a_c: INTEGER): POINTER is 
			-- Parsed as:
			-- GString* g_string_prepend_c (
			--     GString *a_string,
			--     gchar a_c
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_prepend_c (GString	 *string,
			-- 			     gchar	  c);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_insert (a_string: POINTER; a_pos: INTEGER; a_val: POINTER): POINTER is 
			-- Parsed as:
			-- GString* g_string_insert (
			--     GString *a_string,
			--     gint a_pos,
			--     gchar *a_val
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_insert    (GString	 *string,
			-- 			     gint	  pos,
			-- 			     const gchar *val);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_insert_c (a_string: POINTER; a_pos: INTEGER; a_c: INTEGER): POINTER is 
			-- Parsed as:
			-- GString* g_string_insert_c (
			--     GString *a_string,
			--     gint a_pos,
			--     gchar a_c
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_insert_c  (GString	 *string,
			-- 			     gint	  pos,
			-- 			     gchar	  c);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_erase (a_string: POINTER; a_pos: INTEGER; a_len: INTEGER): POINTER is 
			-- Parsed as:
			-- GString* g_string_erase (
			--     GString *a_string,
			--     gint a_pos,
			--     gint a_len
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_erase	    (GString	 *string,
			-- 			     gint	  pos,
			-- 			     gint	  len);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_down (a_string: POINTER): POINTER is 
			-- Parsed as:
			-- GString* g_string_down (
			--     GString *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_down	    (GString	 *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_string_up (a_string: POINTER): POINTER is 
			-- Parsed as:
			-- GString* g_string_up (
			--     GString *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- GString* g_string_up	    (GString	 *string);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_new (a_zero_terminated: BOOLEAN; a_clear: BOOLEAN; a_element_size: INTEGER): POINTER is 
			-- Parsed as:
			-- GArray* g_array_new (
			--     gboolean a_zero_terminated,
			--     gboolean a_clear,
			--     guint a_element_size
			-- );
			--
			-- Original C code from glib.h:
			-- GArray* g_array_new	          (gboolean	    zero_terminated,
			-- 				   gboolean	    clear,
			-- 				   guint	    element_size);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_free (a_array: POINTER; a_free_segment: BOOLEAN) is 
			-- Parsed as:
			-- void g_array_free (
			--     GArray *a_array,
			--     gboolean a_free_segment
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_array_free	          (GArray	   *array,
			-- 				   gboolean	    free_segment);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_append_vals (a_array: POINTER; a_data: POINTER; a_len: INTEGER): POINTER is 
			-- Parsed as:
			-- GArray* g_array_append_vals (
			--     GArray *a_array,
			--     gconstpointer a_data,
			--     guint a_len
			-- );
			--
			-- Original C code from glib.h:
			-- GArray* g_array_append_vals       (GArray	   *array,
			-- 				   gconstpointer    data,
			-- 				   guint	    len);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_prepend_vals (a_array: POINTER; a_data: POINTER; a_len: INTEGER): POINTER is 
			-- Parsed as:
			-- GArray* g_array_prepend_vals (
			--     GArray *a_array,
			--     gconstpointer a_data,
			--     guint a_len
			-- );
			--
			-- Original C code from glib.h:
			-- GArray* g_array_prepend_vals      (GArray	   *array,
			-- 				   gconstpointer    data,
			-- 				   guint	    len);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_insert_vals (a_array: POINTER; a_index: INTEGER; a_data: POINTER; a_len: INTEGER): POINTER is 
			-- Parsed as:
			-- GArray* g_array_insert_vals (
			--     GArray *a_array,
			--     guint a_index,
			--     gconstpointer a_data,
			--     guint a_len
			-- );
			--
			-- Original C code from glib.h:
			-- GArray* g_array_insert_vals       (GArray          *array,
			-- 				   guint            index,
			-- 				   gconstpointer    data,
			-- 				   guint            len);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_set_size (a_array: POINTER; a_length: INTEGER): POINTER is 
			-- Parsed as:
			-- GArray* g_array_set_size (
			--     GArray *a_array,
			--     guint a_length
			-- );
			--
			-- Original C code from glib.h:
			-- GArray* g_array_set_size          (GArray	   *array,
			-- 				   guint	    length);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_remove_index (a_array: POINTER; a_index: INTEGER): POINTER is 
			-- Parsed as:
			-- GArray* g_array_remove_index (
			--     GArray *a_array,
			--     guint a_index
			-- );
			--
			-- Original C code from glib.h:
			-- GArray* g_array_remove_index	  (GArray	   *array,
			-- 				   guint	    index);
		external
			" C | <gtk/gtk.h>"
		end

	g_array_remove_index_fast (a_array: POINTER; a_index: INTEGER): POINTER is 
			-- Parsed as:
			-- GArray* g_array_remove_index_fast (
			--     GArray *a_array,
			--     guint a_index
			-- );
			--
			-- Original C code from glib.h:
			-- GArray* g_array_remove_index_fast (GArray	   *array,
			-- 				   guint	    index);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_new: POINTER is 
			-- Parsed as:
			-- GPtrArray* g_ptr_array_new (
			-- );
			--
			-- Original C code from glib.h:
			-- GPtrArray*  g_ptr_array_new		   (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_free (a_array: POINTER; a_free_seg: BOOLEAN) is 
			-- Parsed as:
			-- void g_ptr_array_free (
			--     GPtrArray *a_array,
			--     gboolean a_free_seg
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_ptr_array_free		   (GPtrArray	*array,
			-- 					    gboolean	 free_seg);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_set_size (a_array: POINTER; a_length: INTEGER) is 
			-- Parsed as:
			-- void g_ptr_array_set_size (
			--     GPtrArray *a_array,
			--     gint a_length
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_ptr_array_set_size	   (GPtrArray	*array,
			-- 					    gint	 length);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_remove_index (a_array: POINTER; a_index: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_ptr_array_remove_index (
			--     GPtrArray *a_array,
			--     guint a_index
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer    g_ptr_array_remove_index	   (GPtrArray	*array,
			-- 					    guint	 index);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_remove_index_fast (a_array: POINTER; a_index: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_ptr_array_remove_index_fast (
			--     GPtrArray *a_array,
			--     guint a_index
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer    g_ptr_array_remove_index_fast  (GPtrArray	*array,
			-- 					    guint	 index);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_remove (a_array: POINTER; a_data: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_ptr_array_remove (
			--     GPtrArray *a_array,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean    g_ptr_array_remove		   (GPtrArray	*array,
			-- 					    gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_remove_fast (a_array: POINTER; a_data: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_ptr_array_remove_fast (
			--     GPtrArray *a_array,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean    g_ptr_array_remove_fast        (GPtrArray	*array,
			-- 					    gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_ptr_array_add (a_array: POINTER; a_data: POINTER) is 
			-- Parsed as:
			-- void g_ptr_array_add (
			--     GPtrArray *a_array,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_ptr_array_add		   (GPtrArray	*array,
			-- 					    gpointer	 data);
		external
			" C | <gtk/gtk.h>"
		end

	g_byte_array_new: POINTER is 
			-- Parsed as:
			-- GByteArray* g_byte_array_new (
			-- );
			--
			-- Original C code from glib.h:
			-- GByteArray* g_byte_array_new	           (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_byte_array_free (a_array: POINTER; a_free_segment: BOOLEAN) is 
			-- Parsed as:
			-- void g_byte_array_free (
			--     GByteArray *a_array,
			--     gboolean a_free_segment
			-- );
			--
			-- Original C code from glib.h:
			-- void	    g_byte_array_free	           (GByteArray	 *array,
			-- 					    gboolean	  free_segment);
		external
			" C | <gtk/gtk.h>"
		end

	g_byte_array_append (a_array: POINTER; a_data: POINTER; a_len: INTEGER): POINTER is 
			-- Parsed as:
			-- GByteArray* g_byte_array_append (
			--     GByteArray *a_array,
			--     guint8 *a_data,
			--     guint a_len
			-- );
			--
			-- Original C code from glib.h:
			-- GByteArray* g_byte_array_append	           (GByteArray	 *array,
			-- 					    const guint8 *data,
			-- 					    guint	  len);
		external
			" C | <gtk/gtk.h>"
		end

	g_byte_array_prepend (a_array: POINTER; a_data: POINTER; a_len: INTEGER): POINTER is 
			-- Parsed as:
			-- GByteArray* g_byte_array_prepend (
			--     GByteArray *a_array,
			--     guint8 *a_data,
			--     guint a_len
			-- );
			--
			-- Original C code from glib.h:
			-- GByteArray* g_byte_array_prepend           (GByteArray	 *array,
			-- 					    const guint8 *data,
			-- 					    guint	  len);
		external
			" C | <gtk/gtk.h>"
		end

	g_byte_array_set_size (a_array: POINTER; a_length: INTEGER): POINTER is 
			-- Parsed as:
			-- GByteArray* g_byte_array_set_size (
			--     GByteArray *a_array,
			--     guint a_length
			-- );
			--
			-- Original C code from glib.h:
			-- GByteArray* g_byte_array_set_size          (GByteArray	 *array,
			-- 					    guint	  length);
		external
			" C | <gtk/gtk.h>"
		end

	g_byte_array_remove_index (a_array: POINTER; a_index: INTEGER): POINTER is 
			-- Parsed as:
			-- GByteArray* g_byte_array_remove_index (
			--     GByteArray *a_array,
			--     guint a_index
			-- );
			--
			-- Original C code from glib.h:
			-- GByteArray* g_byte_array_remove_index	   (GByteArray	 *array,
			-- 					    guint	  index);
		external
			" C | <gtk/gtk.h>"
		end

	g_byte_array_remove_index_fast (a_array: POINTER; a_index: INTEGER): POINTER is 
			-- Parsed as:
			-- GByteArray* g_byte_array_remove_index_fast (
			--     GByteArray *a_array,
			--     guint a_index
			-- );
			--
			-- Original C code from glib.h:
			-- GByteArray* g_byte_array_remove_index_fast (GByteArray	 *array,
			-- 					    guint	  index);
		external
			" C | <gtk/gtk.h>"
		end

	g_str_equal (a_v: POINTER; a_v2: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_str_equal (
			--     gconstpointer a_v,
			--     gconstpointer a_v2
			-- );
			--
			-- Original C code from glib.h:
			-- gint  g_str_equal (gconstpointer   v,
			-- 		   gconstpointer   v2);
		external
			" C | <gtk/gtk.h>"
		end

	g_str_hash (a_v: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_str_hash (
			--     gconstpointer a_v
			-- );
			--
			-- Original C code from glib.h:
			-- guint g_str_hash  (gconstpointer   v);
		external
			" C | <gtk/gtk.h>"
		end

	g_int_equal (a_v: POINTER; a_v2: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_int_equal (
			--     gconstpointer a_v,
			--     gconstpointer a_v2
			-- );
			--
			-- Original C code from glib.h:
			-- gint  g_int_equal (gconstpointer   v,
			-- 		   gconstpointer   v2);
		external
			" C | <gtk/gtk.h>"
		end

	g_int_hash (a_v: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_int_hash (
			--     gconstpointer a_v
			-- );
			--
			-- Original C code from glib.h:
			-- guint g_int_hash  (gconstpointer   v);
		external
			" C | <gtk/gtk.h>"
		end

	g_direct_hash (a_v: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_direct_hash (
			--     gconstpointer a_v
			-- );
			--
			-- Original C code from glib.h:
			-- guint g_direct_hash  (gconstpointer v);
		external
			" C | <gtk/gtk.h>"
		end

	g_direct_equal (a_v: POINTER; a_v2: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_direct_equal (
			--     gconstpointer a_v,
			--     gconstpointer a_v2
			-- );
			--
			-- Original C code from glib.h:
			-- gint  g_direct_equal (gconstpointer v,
			-- 		      gconstpointer v2);
		external
			" C | <gtk/gtk.h>"
		end

	g_quark_try_string (a_string: POINTER): INTEGER is 
			-- Parsed as:
			-- GQuark g_quark_try_string (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- GQuark	  g_quark_try_string		(const gchar	*string);
		external
			" C | <gtk/gtk.h>"
		end

	g_quark_from_static_string (a_string: POINTER): INTEGER is 
			-- Parsed as:
			-- GQuark g_quark_from_static_string (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- GQuark	  g_quark_from_static_string	(const gchar	*string);
		external
			" C | <gtk/gtk.h>"
		end

	g_quark_from_string (a_string: POINTER): INTEGER is 
			-- Parsed as:
			-- GQuark g_quark_from_string (
			--     gchar *a_string
			-- );
			--
			-- Original C code from glib.h:
			-- GQuark	  g_quark_from_string		(const gchar	*string);
		external
			" C | <gtk/gtk.h>"
		end

	g_quark_to_string (a_quark: INTEGER): POINTER is 
			-- Parsed as:
			-- gchar* g_quark_to_string (
			--     GQuark a_quark
			-- );
			--
			-- Original C code from glib.h:
			-- gchar*	  g_quark_to_string		(GQuark		 quark);
		external
			" C | <gtk/gtk.h>"
		end

	g_datalist_init (a_datalist: POINTER) is 
			-- Parsed as:
			-- void g_datalist_init (
			--     GData **a_datalist
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_datalist_init		 (GData		 **datalist);
		external
			" C | <gtk/gtk.h>"
		end

	g_datalist_clear (a_datalist: POINTER) is 
			-- Parsed as:
			-- void g_datalist_clear (
			--     GData **a_datalist
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_datalist_clear		 (GData		 **datalist);
		external
			" C | <gtk/gtk.h>"
		end

	g_datalist_id_get_data (a_datalist: POINTER; a_key_id: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_datalist_id_get_data (
			--     GData **a_datalist,
			--     GQuark a_key_id
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer  g_datalist_id_get_data	 (GData		 **datalist,
			-- 					  GQuark	   key_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_datalist_id_set_data_full (a_datalist: POINTER; a_key_id: INTEGER; a_data: POINTER; a_destroy_func: POINTER) is 
			-- Parsed as:
			-- void g_datalist_id_set_data_full (
			--     GData **a_datalist,
			--     GQuark a_key_id,
			--     gpointer a_data,
			--     GDestroyNotify a_destroy_func
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_datalist_id_set_data_full	 (GData		 **datalist,
			-- 					  GQuark	   key_id,
			-- 					  gpointer	   data,
			-- 					  GDestroyNotify   destroy_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_datalist_id_remove_no_notify (a_datalist: POINTER; a_key_id: INTEGER) is 
			-- Parsed as:
			-- void g_datalist_id_remove_no_notify (
			--     GData **a_datalist,
			--     GQuark a_key_id
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_datalist_id_remove_no_notify (GData		 **datalist,
			-- 					  GQuark	   key_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_datalist_foreach (a_datalist: POINTER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_datalist_foreach (
			--     GData **a_datalist,
			--     GDataForeachFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_datalist_foreach		 (GData		 **datalist,
			-- 					  GDataForeachFunc func,
			-- 					  gpointer	   user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_dataset_destroy (a_dataset_location: POINTER) is 
			-- Parsed as:
			-- void g_dataset_destroy (
			--     gconstpointer a_dataset_location
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_dataset_destroy		(gconstpointer	  dataset_location);
		external
			" C | <gtk/gtk.h>"
		end

	g_dataset_id_get_data (a_dataset_location: POINTER; a_key_id: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_dataset_id_get_data (
			--     gconstpointer a_dataset_location,
			--     GQuark a_key_id
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer  g_dataset_id_get_data		(gconstpointer	  dataset_location,
			-- 					 GQuark		  key_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_dataset_id_set_data_full (a_dataset_location: POINTER; a_key_id: INTEGER; a_data: POINTER; a_destroy_func: POINTER) is 
			-- Parsed as:
			-- void g_dataset_id_set_data_full (
			--     gconstpointer a_dataset_location,
			--     GQuark a_key_id,
			--     gpointer a_data,
			--     GDestroyNotify a_destroy_func
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_dataset_id_set_data_full	(gconstpointer	  dataset_location,
			-- 					 GQuark		  key_id,
			-- 					 gpointer	  data,
			-- 					 GDestroyNotify	  destroy_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_dataset_id_remove_no_notify (a_dataset_location: POINTER; a_key_id: INTEGER) is 
			-- Parsed as:
			-- void g_dataset_id_remove_no_notify (
			--     gconstpointer a_dataset_location,
			--     GQuark a_key_id
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_dataset_id_remove_no_notify	(gconstpointer	  dataset_location,
			-- 					 GQuark		  key_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_dataset_foreach (a_dataset_location: POINTER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_dataset_foreach (
			--     gconstpointer a_dataset_location,
			--     GDataForeachFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void	  g_dataset_foreach		(gconstpointer	  dataset_location,
			-- 					 GDataForeachFunc func,
			-- 					 gpointer	  user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_new (a_config_templ: POINTER): POINTER is 
			-- Parsed as:
			-- GScanner* g_scanner_new (
			--     GScannerConfig *a_config_templ
			-- );
			--
			-- Original C code from glib.h:
			-- GScanner*	g_scanner_new			(GScannerConfig *config_templ);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_destroy (a_scanner: POINTER) is 
			-- Parsed as:
			-- void g_scanner_destroy (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_destroy		(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_input_file (a_scanner: POINTER; a_input_fd: INTEGER) is 
			-- Parsed as:
			-- void g_scanner_input_file (
			--     GScanner *a_scanner,
			--     gint a_input_fd
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_input_file		(GScanner	*scanner,
			-- 						 gint		input_fd);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_sync_file_offset (a_scanner: POINTER) is 
			-- Parsed as:
			-- void g_scanner_sync_file_offset (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_sync_file_offset	(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_input_text (a_scanner: POINTER; a_text: POINTER; a_text_len: INTEGER) is 
			-- Parsed as:
			-- void g_scanner_input_text (
			--     GScanner *a_scanner,
			--     gchar *a_text,
			--     guint a_text_len
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_input_text		(GScanner	*scanner,
			-- 						 const	gchar	*text,
			-- 						 guint		text_len);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_get_next_token (a_scanner: POINTER): INTEGER is 
			-- Parsed as:
			-- GTokenType g_scanner_get_next_token (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- GTokenType	g_scanner_get_next_token	(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_peek_next_token (a_scanner: POINTER): INTEGER is 
			-- Parsed as:
			-- GTokenType g_scanner_peek_next_token (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- GTokenType	g_scanner_peek_next_token	(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_cur_token (a_scanner: POINTER): INTEGER is 
			-- Parsed as:
			-- GTokenType g_scanner_cur_token (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- GTokenType	g_scanner_cur_token		(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_cur_value (a_scanner: POINTER): union is 
			-- Parsed as:
			-- GTokenValue g_scanner_cur_value (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- GTokenValue	g_scanner_cur_value		(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_cur_line (a_scanner: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_scanner_cur_line (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- guint		g_scanner_cur_line		(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_cur_position (a_scanner: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_scanner_cur_position (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- guint		g_scanner_cur_position		(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_eof (a_scanner: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_scanner_eof (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean	g_scanner_eof			(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_set_scope (a_scanner: POINTER; a_scope_id: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint g_scanner_set_scope (
			--     GScanner *a_scanner,
			--     guint a_scope_id
			-- );
			--
			-- Original C code from glib.h:
			-- guint		g_scanner_set_scope		(GScanner	*scanner,
			-- 						 guint		 scope_id);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_scope_add_symbol (a_scanner: POINTER; a_scope_id: INTEGER; a_symbol: POINTER; a_value: POINTER) is 
			-- Parsed as:
			-- void g_scanner_scope_add_symbol (
			--     GScanner *a_scanner,
			--     guint a_scope_id,
			--     gchar *a_symbol,
			--     gpointer a_value
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_scope_add_symbol	(GScanner	*scanner,
			-- 						 guint		 scope_id,
			-- 						 const gchar	*symbol,
			-- 						 gpointer	value);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_scope_remove_symbol (a_scanner: POINTER; a_scope_id: INTEGER; a_symbol: POINTER) is 
			-- Parsed as:
			-- void g_scanner_scope_remove_symbol (
			--     GScanner *a_scanner,
			--     guint a_scope_id,
			--     gchar *a_symbol
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_scope_remove_symbol	(GScanner	*scanner,
			-- 						 guint		 scope_id,
			-- 						 const gchar	*symbol);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_scope_lookup_symbol (a_scanner: POINTER; a_scope_id: INTEGER; a_symbol: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_scanner_scope_lookup_symbol (
			--     GScanner *a_scanner,
			--     guint a_scope_id,
			--     gchar *a_symbol
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer	g_scanner_scope_lookup_symbol	(GScanner	*scanner,
			-- 						 guint		 scope_id,
			-- 						 const gchar	*symbol);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_scope_foreach_symbol (a_scanner: POINTER; a_scope_id: INTEGER; a_func: POINTER; a_user_data: POINTER) is 
			-- Parsed as:
			-- void g_scanner_scope_foreach_symbol (
			--     GScanner *a_scanner,
			--     guint a_scope_id,
			--     GHFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_scope_foreach_symbol	(GScanner	*scanner,
			-- 						 guint		 scope_id,
			-- 						 GHFunc		 func,
			-- 						 gpointer	 user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_lookup_symbol (a_scanner: POINTER; a_symbol: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_scanner_lookup_symbol (
			--     GScanner *a_scanner,
			--     gchar *a_symbol
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer	g_scanner_lookup_symbol		(GScanner	*scanner,
			-- 						 const gchar	*symbol);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_freeze_symbol_table (a_scanner: POINTER) is 
			-- Parsed as:
			-- void g_scanner_freeze_symbol_table (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_freeze_symbol_table	(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_thaw_symbol_table (a_scanner: POINTER) is 
			-- Parsed as:
			-- void g_scanner_thaw_symbol_table (
			--     GScanner *a_scanner
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_thaw_symbol_table	(GScanner	*scanner);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_unexp_token (a_scanner: POINTER; a_expected_token: INTEGER; a_identifier_spec: POINTER; a_symbol_spec: POINTER; a_symbol_name: POINTER; a_message: POINTER; a_is_error: INTEGER) is 
			-- Parsed as:
			-- void g_scanner_unexp_token (
			--     GScanner *a_scanner,
			--     GTokenType a_expected_token,
			--     gchar *a_identifier_spec,
			--     gchar *a_symbol_spec,
			--     gchar *a_symbol_name,
			--     gchar *a_message,
			--     gint a_is_error
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_scanner_unexp_token		(GScanner	*scanner,
			-- 						 GTokenType	expected_token,
			-- 						 const gchar	*identifier_spec,
			-- 						 const gchar	*symbol_spec,
			-- 						 const gchar	*symbol_name,
			-- 						 const gchar	*message,
			-- 						 gint		 is_error);
		external
			" C | <gtk/gtk.h>"
		end

	g_scanner_stat_mode (a_filename: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_scanner_stat_mode (
			--     gchar *a_filename
			-- );
			--
			-- Original C code from glib.h:
			-- gint		g_scanner_stat_mode		(const gchar	*filename);
		external
			" C | <gtk/gtk.h>"
		end

	g_completion_new (a_func: POINTER): POINTER is 
			-- Parsed as:
			-- GCompletion* g_completion_new (
			--     GCompletionFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- GCompletion* g_completion_new	       (GCompletionFunc func);
		external
			" C | <gtk/gtk.h>"
		end

	g_completion_add_items (a_cmp: POINTER; a_items: POINTER) is 
			-- Parsed as:
			-- void g_completion_add_items (
			--     GCompletion *a_cmp,
			--     GList *a_items
			-- );
			--
			-- Original C code from glib.h:
			-- void	     g_completion_add_items    (GCompletion*	cmp,
			-- 					GList*		items);
		external
			" C | <gtk/gtk.h>"
		end

	g_completion_remove_items (a_cmp: POINTER; a_items: POINTER) is 
			-- Parsed as:
			-- void g_completion_remove_items (
			--     GCompletion *a_cmp,
			--     GList *a_items
			-- );
			--
			-- Original C code from glib.h:
			-- void	     g_completion_remove_items (GCompletion*	cmp,
			-- 					GList*		items);
		external
			" C | <gtk/gtk.h>"
		end

	g_completion_clear_items (a_cmp: POINTER) is 
			-- Parsed as:
			-- void g_completion_clear_items (
			--     GCompletion *a_cmp
			-- );
			--
			-- Original C code from glib.h:
			-- void	     g_completion_clear_items  (GCompletion*	cmp);
		external
			" C | <gtk/gtk.h>"
		end

	g_completion_complete (a_cmp: POINTER; a_prefix: POINTER; a_new_prefix: POINTER): POINTER is 
			-- Parsed as:
			-- GList* g_completion_complete (
			--     GCompletion *a_cmp,
			--     gchar *a_prefix,
			--     gchar **a_new_prefix
			-- );
			--
			-- Original C code from glib.h:
			-- GList*	     g_completion_complete     (GCompletion*	cmp,
			-- 					gchar*		prefix,
			-- 					gchar**		new_prefix);
		external
			" C | <gtk/gtk.h>"
		end

	g_completion_free (a_cmp: POINTER) is 
			-- Parsed as:
			-- void g_completion_free (
			--     GCompletion *a_cmp
			-- );
			--
			-- Original C code from glib.h:
			-- void	     g_completion_free	       (GCompletion*	cmp);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_new: POINTER is 
			-- Parsed as:
			-- GDate* g_date_new (
			-- );
			--
			-- Original C code from glib.h:
			-- GDate*       g_date_new                   (void);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_new_dmy (a_day: INTEGER; a_month: INTEGER; a_year: INTEGER): POINTER is 
			-- Parsed as:
			-- GDate* g_date_new_dmy (
			--     GDateDay a_day,
			--     GDateMonth a_month,
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- GDate*       g_date_new_dmy               (GDateDay     day, 
			--                                            GDateMonth   month, 
			--                                            GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_new_julian (a_julian_day: INTEGER): POINTER is 
			-- Parsed as:
			-- GDate* g_date_new_julian (
			--     guint32 a_julian_day
			-- );
			--
			-- Original C code from glib.h:
			-- GDate*       g_date_new_julian            (guint32      julian_day);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_free (a_date: POINTER) is 
			-- Parsed as:
			-- void g_date_free (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_free                  (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_valid (a_date: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_valid (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_valid                 (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_valid_day (a_day: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_valid_day (
			--     GDateDay a_day
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_valid_day             (GDateDay     day);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_valid_month (a_month: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_valid_month (
			--     GDateMonth a_month
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_valid_month           (GDateMonth   month);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_valid_year (a_year: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_valid_year (
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_valid_year            (GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_valid_weekday (a_weekday: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_valid_weekday (
			--     GDateWeekday a_weekday
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_valid_weekday         (GDateWeekday weekday);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_valid_julian (a_julian_date: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_valid_julian (
			--     guint32 a_julian_date
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_valid_julian          (guint32      julian_date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_valid_dmy (a_day: INTEGER; a_month: INTEGER; a_year: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_valid_dmy (
			--     GDateDay a_day,
			--     GDateMonth a_month,
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_valid_dmy             (GDateDay     day,
			--                                            GDateMonth   month,
			--                                            GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_weekday (a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- GDateWeekday g_date_weekday (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- GDateWeekday g_date_weekday               (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_month (a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- GDateMonth g_date_month (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- GDateMonth   g_date_month                 (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_year (a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- GDateYear g_date_year (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- GDateYear    g_date_year                  (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_day (a_date: POINTER): char is 
			-- Parsed as:
			-- GDateDay g_date_day (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- GDateDay     g_date_day                   (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_julian (a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- guint32 g_date_julian (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- guint32      g_date_julian                (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_day_of_year (a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_date_day_of_year (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- guint        g_date_day_of_year           (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_monday_week_of_year (a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_date_monday_week_of_year (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- guint        g_date_monday_week_of_year   (GDate      *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_sunday_week_of_year (a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_date_sunday_week_of_year (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- guint        g_date_sunday_week_of_year   (GDate      *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_clear (a_date: POINTER; a_n_dates: INTEGER) is 
			-- Parsed as:
			-- void g_date_clear (
			--     GDate *a_date,
			--     guint a_n_dates
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_clear                 (GDate       *date, 
			--                                            guint        n_dates);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_set_parse (a_date: POINTER; a_str: POINTER) is 
			-- Parsed as:
			-- void g_date_set_parse (
			--     GDate *a_date,
			--     gchar *a_str
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_set_parse             (GDate       *date,
			--                                            const gchar *str);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_set_time (a_date: POINTER; a_time: INTEGER) is 
			-- Parsed as:
			-- void g_date_set_time (
			--     GDate *a_date,
			--     GTime a_time
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_set_time              (GDate       *date, 
			--                                            GTime        time);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_set_month (a_date: POINTER; a_month: INTEGER) is 
			-- Parsed as:
			-- void g_date_set_month (
			--     GDate *a_date,
			--     GDateMonth a_month
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_set_month             (GDate       *date, 
			--                                            GDateMonth   month);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_set_day (a_date: POINTER; a_day: INTEGER) is 
			-- Parsed as:
			-- void g_date_set_day (
			--     GDate *a_date,
			--     GDateDay a_day
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_set_day               (GDate       *date, 
			--                                            GDateDay     day);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_set_year (a_date: POINTER; a_year: INTEGER) is 
			-- Parsed as:
			-- void g_date_set_year (
			--     GDate *a_date,
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_set_year              (GDate       *date,
			--                                            GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_set_dmy (a_date: POINTER; a_day: INTEGER; a_month: INTEGER; a_y: INTEGER) is 
			-- Parsed as:
			-- void g_date_set_dmy (
			--     GDate *a_date,
			--     GDateDay a_day,
			--     GDateMonth a_month,
			--     GDateYear a_y
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_set_dmy               (GDate       *date,
			--                                            GDateDay     day,
			--                                            GDateMonth   month,
			--                                            GDateYear    y);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_set_julian (a_date: POINTER; a_julian_date: INTEGER) is 
			-- Parsed as:
			-- void g_date_set_julian (
			--     GDate *a_date,
			--     guint32 a_julian_date
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_set_julian            (GDate       *date,
			--                                            guint32      julian_date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_is_first_of_month (a_date: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_is_first_of_month (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_is_first_of_month     (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_is_last_of_month (a_date: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_is_last_of_month (
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_is_last_of_month      (GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_add_days (a_date: POINTER; a_n_days: INTEGER) is 
			-- Parsed as:
			-- void g_date_add_days (
			--     GDate *a_date,
			--     guint a_n_days
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_add_days              (GDate       *date, 
			--                                            guint        n_days);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_subtract_days (a_date: POINTER; a_n_days: INTEGER) is 
			-- Parsed as:
			-- void g_date_subtract_days (
			--     GDate *a_date,
			--     guint a_n_days
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_subtract_days         (GDate       *date, 
			--                                            guint        n_days);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_add_months (a_date: POINTER; a_n_months: INTEGER) is 
			-- Parsed as:
			-- void g_date_add_months (
			--     GDate *a_date,
			--     guint a_n_months
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_add_months            (GDate       *date,
			--                                            guint        n_months);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_subtract_months (a_date: POINTER; a_n_months: INTEGER) is 
			-- Parsed as:
			-- void g_date_subtract_months (
			--     GDate *a_date,
			--     guint a_n_months
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_subtract_months       (GDate       *date,
			--                                            guint        n_months);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_add_years (a_date: POINTER; a_n_years: INTEGER) is 
			-- Parsed as:
			-- void g_date_add_years (
			--     GDate *a_date,
			--     guint a_n_years
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_add_years             (GDate       *date,
			--                                            guint        n_years);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_subtract_years (a_date: POINTER; a_n_years: INTEGER) is 
			-- Parsed as:
			-- void g_date_subtract_years (
			--     GDate *a_date,
			--     guint a_n_years
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_subtract_years        (GDate       *date,
			--                                            guint        n_years);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_is_leap_year (a_year: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_date_is_leap_year (
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean     g_date_is_leap_year          (GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_days_in_month (a_month: INTEGER; a_year: INTEGER): char is 
			-- Parsed as:
			-- guint8 g_date_days_in_month (
			--     GDateMonth a_month,
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- guint8       g_date_days_in_month         (GDateMonth   month, 
			--                                            GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_monday_weeks_in_year (a_year: INTEGER): char is 
			-- Parsed as:
			-- guint8 g_date_monday_weeks_in_year (
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- guint8       g_date_monday_weeks_in_year  (GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_sunday_weeks_in_year (a_year: INTEGER): char is 
			-- Parsed as:
			-- guint8 g_date_sunday_weeks_in_year (
			--     GDateYear a_year
			-- );
			--
			-- Original C code from glib.h:
			-- guint8       g_date_sunday_weeks_in_year  (GDateYear    year);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_compare (a_lhs: POINTER; a_rhs: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_date_compare (
			--     GDate *a_lhs,
			--     GDate *a_rhs
			-- );
			--
			-- Original C code from glib.h:
			-- gint         g_date_compare               (GDate       *lhs,
			--                                            GDate       *rhs);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_to_struct_tm (a_date: POINTER; a_tm: POINTER) is 
			-- Parsed as:
			-- void g_date_to_struct_tm (
			--     GDate *a_date,
			--     tm *a_tm
			-- );
			--
			-- Original C code from glib.h:
			-- void         g_date_to_struct_tm          (GDate       *date,
			--                                            struct tm   *tm);
		external
			" C | <gtk/gtk.h>"
		end

	g_date_strftime (a_s: POINTER; a_slen: INTEGER; a_format: POINTER; a_date: POINTER): INTEGER is 
			-- Parsed as:
			-- gsize g_date_strftime (
			--     gchar *a_s,
			--     gsize a_slen,
			--     gchar *a_format,
			--     GDate *a_date
			-- );
			--
			-- Original C code from glib.h:
			-- gsize        g_date_strftime              (gchar       *s,
			--                                            gsize        slen,
			--                                            const gchar *format,
			--                                            GDate       *date);
		external
			" C | <gtk/gtk.h>"
		end

	g_relation_new (a_fields: INTEGER): POINTER is 
			-- Parsed as:
			-- GRelation* g_relation_new (
			--     gint a_fields
			-- );
			--
			-- Original C code from glib.h:
			-- GRelation* g_relation_new     (gint	    fields);
		external
			" C | <gtk/gtk.h>"
		end

	g_relation_destroy (a_relation: POINTER) is 
			-- Parsed as:
			-- void g_relation_destroy (
			--     GRelation *a_relation
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_relation_destroy (GRelation   *relation);
		external
			" C | <gtk/gtk.h>"
		end

	g_relation_index (a_relation: POINTER; a_field: INTEGER; a_hash_func: POINTER; a_key_compare_func: POINTER) is 
			-- Parsed as:
			-- void g_relation_index (
			--     GRelation *a_relation,
			--     gint a_field,
			--     GHashFunc a_hash_func,
			--     GCompareFunc a_key_compare_func
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_relation_index   (GRelation   *relation,
			-- 			       gint	    field,
			-- 			       GHashFunc    hash_func,
			-- 			       GCompareFunc key_compare_func);
		external
			" C | <gtk/gtk.h>"
		end

	g_relation_delete (a_relation: POINTER; a_key: POINTER; a_field: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint g_relation_delete (
			--     GRelation *a_relation,
			--     gconstpointer a_key,
			--     gint a_field
			-- );
			--
			-- Original C code from glib.h:
			-- gint	   g_relation_delete  (GRelation   *relation,
			-- 			       gconstpointer  key,
			-- 			       gint	    field);
		external
			" C | <gtk/gtk.h>"
		end

	g_relation_select (a_relation: POINTER; a_key: POINTER; a_field: INTEGER): POINTER is 
			-- Parsed as:
			-- GTuples* g_relation_select (
			--     GRelation *a_relation,
			--     gconstpointer a_key,
			--     gint a_field
			-- );
			--
			-- Original C code from glib.h:
			-- GTuples*   g_relation_select  (GRelation   *relation,
			-- 			       gconstpointer  key,
			-- 			       gint	    field);
		external
			" C | <gtk/gtk.h>"
		end

	g_relation_count (a_relation: POINTER; a_key: POINTER; a_field: INTEGER): INTEGER is 
			-- Parsed as:
			-- gint g_relation_count (
			--     GRelation *a_relation,
			--     gconstpointer a_key,
			--     gint a_field
			-- );
			--
			-- Original C code from glib.h:
			-- gint	   g_relation_count   (GRelation   *relation,
			-- 			       gconstpointer  key,
			-- 			       gint	    field);
		external
			" C | <gtk/gtk.h>"
		end

	g_relation_print (a_relation: POINTER) is 
			-- Parsed as:
			-- void g_relation_print (
			--     GRelation *a_relation
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_relation_print   (GRelation   *relation);
		external
			" C | <gtk/gtk.h>"
		end

	g_tuples_destroy (a_tuples: POINTER) is 
			-- Parsed as:
			-- void g_tuples_destroy (
			--     GTuples *a_tuples
			-- );
			--
			-- Original C code from glib.h:
			-- void	   g_tuples_destroy   (GTuples	   *tuples);
		external
			" C | <gtk/gtk.h>"
		end

	g_tuples_index (a_tuples: POINTER; a_index: INTEGER; a_field: INTEGER): POINTER is 
			-- Parsed as:
			-- gpointer g_tuples_index (
			--     GTuples *a_tuples,
			--     gint a_index,
			--     gint a_field
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer   g_tuples_index     (GTuples	   *tuples,
			-- 			       gint	    index,
			-- 			       gint	    field);
		external
			" C | <gtk/gtk.h>"
		end

	g_spaced_primes_closest (a_num: INTEGER): INTEGER is 
			-- Parsed as:
			-- guint g_spaced_primes_closest (
			--     guint a_num
			-- );
			--
			-- Original C code from glib.h:
			-- guint	   g_spaced_primes_closest (guint num);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_init (a_channel: POINTER) is 
			-- Parsed as:
			-- void g_io_channel_init (
			--     GIOChannel *a_channel
			-- );
			--
			-- Original C code from glib.h:
			-- void        g_io_channel_init   (GIOChannel    *channel);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_ref (a_channel: POINTER) is 
			-- Parsed as:
			-- void g_io_channel_ref (
			--     GIOChannel *a_channel
			-- );
			--
			-- Original C code from glib.h:
			-- void        g_io_channel_ref    (GIOChannel    *channel);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_unref (a_channel: POINTER) is 
			-- Parsed as:
			-- void g_io_channel_unref (
			--     GIOChannel *a_channel
			-- );
			--
			-- Original C code from glib.h:
			-- void        g_io_channel_unref  (GIOChannel    *channel);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_read (a_channel: POINTER; a_buf: POINTER; a_count: INTEGER; a_bytes_read: POINTER): INTEGER is 
			-- Parsed as:
			-- GIOError g_io_channel_read (
			--     GIOChannel *a_channel,
			--     gchar *a_buf,
			--     guint a_count,
			--     guint *a_bytes_read
			-- );
			--
			-- Original C code from glib.h:
			-- GIOError    g_io_channel_read   (GIOChannel    *channel, 
			-- 			         gchar         *buf, 
			-- 			         guint          count,
			-- 			         guint         *bytes_read);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_write (a_channel: POINTER; a_buf: POINTER; a_count: INTEGER; a_bytes_written: POINTER): INTEGER is 
			-- Parsed as:
			-- GIOError g_io_channel_write (
			--     GIOChannel *a_channel,
			--     gchar *a_buf,
			--     guint a_count,
			--     guint *a_bytes_written
			-- );
			--
			-- Original C code from glib.h:
			-- GIOError  g_io_channel_write    (GIOChannel    *channel, 
			-- 			         gchar         *buf, 
			-- 			         guint          count,
			-- 			         guint         *bytes_written);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_seek (a_channel: POINTER; a_offset: INTEGER; a_type: INTEGER): INTEGER is 
			-- Parsed as:
			-- GIOError g_io_channel_seek (
			--     GIOChannel *a_channel,
			--     gint a_offset,
			--     GSeekType a_type
			-- );
			--
			-- Original C code from glib.h:
			-- GIOError  g_io_channel_seek     (GIOChannel    *channel,
			-- 			         gint           offset, 
			-- 			         GSeekType      type);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_close (a_channel: POINTER) is 
			-- Parsed as:
			-- void g_io_channel_close (
			--     GIOChannel *a_channel
			-- );
			--
			-- Original C code from glib.h:
			-- void      g_io_channel_close    (GIOChannel    *channel);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_add_watch_full (a_channel: POINTER; a_priority: INTEGER; a_condition: INTEGER; a_func: POINTER; a_user_data: POINTER; a_notify: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_io_add_watch_full (
			--     GIOChannel *a_channel,
			--     gint a_priority,
			--     GIOCondition a_condition,
			--     GIOFunc a_func,
			--     gpointer a_user_data,
			--     GDestroyNotify a_notify
			-- );
			--
			-- Original C code from glib.h:
			-- guint     g_io_add_watch_full   (GIOChannel    *channel,
			-- 			         gint           priority,
			-- 			         GIOCondition   condition,
			-- 			         GIOFunc        func,
			-- 			         gpointer       user_data,
			-- 			         GDestroyNotify notify);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_add_watch (a_channel: POINTER; a_condition: INTEGER; a_func: POINTER; a_user_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_io_add_watch (
			--     GIOChannel *a_channel,
			--     GIOCondition a_condition,
			--     GIOFunc a_func,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- guint    g_io_add_watch         (GIOChannel    *channel,
			-- 			         GIOCondition   condition,
			-- 			         GIOFunc        func,
			-- 			         gpointer       user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_source_add (a_priority: INTEGER; a_can_recurse: BOOLEAN; a_funcs: POINTER; a_source_data: POINTER; a_user_data: POINTER; a_notify: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_source_add (
			--     gint a_priority,
			--     gboolean a_can_recurse,
			--     GSourceFuncs *a_funcs,
			--     gpointer a_source_data,
			--     gpointer a_user_data,
			--     GDestroyNotify a_notify
			-- );
			--
			-- Original C code from glib.h:
			-- guint    g_source_add                        (gint           priority, 
			-- 					      gboolean       can_recurse,
			-- 					      GSourceFuncs  *funcs,
			-- 					      gpointer       source_data, 
			-- 					      gpointer       user_data,
			-- 					      GDestroyNotify notify);
		external
			" C | <gtk/gtk.h>"
		end

	g_source_remove (a_tag: INTEGER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_source_remove (
			--     guint a_tag
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean g_source_remove                     (guint          tag);
		external
			" C | <gtk/gtk.h>"
		end

	g_source_remove_by_user_data (a_user_data: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_source_remove_by_user_data (
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean g_source_remove_by_user_data        (gpointer       user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_source_remove_by_source_data (a_source_data: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_source_remove_by_source_data (
			--     gpointer a_source_data
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean g_source_remove_by_source_data      (gpointer       source_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_source_remove_by_funcs_user_data (a_funcs: POINTER; a_user_data: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_source_remove_by_funcs_user_data (
			--     GSourceFuncs *a_funcs,
			--     gpointer a_user_data
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean g_source_remove_by_funcs_user_data  (GSourceFuncs  *funcs,
			-- 					      gpointer       user_data);
		external
			" C | <gtk/gtk.h>"
		end

	g_get_current_time (a_result: POINTER) is 
			-- Parsed as:
			-- void g_get_current_time (
			--     GTimeVal *a_result
			-- );
			--
			-- Original C code from glib.h:
			-- void g_get_current_time		    (GTimeVal	   *result);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_new (a_is_running: BOOLEAN): POINTER is 
			-- Parsed as:
			-- GMainLoop* g_main_new (
			--     gboolean a_is_running
			-- );
			--
			-- Original C code from glib.h:
			-- GMainLoop*	g_main_new		(gboolean	 is_running);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_run (a_loop: POINTER) is 
			-- Parsed as:
			-- void g_main_run (
			--     GMainLoop *a_loop
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_main_run		(GMainLoop	*loop);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_quit (a_loop: POINTER) is 
			-- Parsed as:
			-- void g_main_quit (
			--     GMainLoop *a_loop
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_main_quit		(GMainLoop	*loop);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_destroy (a_loop: POINTER) is 
			-- Parsed as:
			-- void g_main_destroy (
			--     GMainLoop *a_loop
			-- );
			--
			-- Original C code from glib.h:
			-- void		g_main_destroy		(GMainLoop	*loop);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_is_running (a_loop: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_main_is_running (
			--     GMainLoop *a_loop
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean	g_main_is_running	(GMainLoop	*loop);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_iteration (a_may_block: BOOLEAN): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_main_iteration (
			--     gboolean a_may_block
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean	g_main_iteration	(gboolean	may_block);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_pending: BOOLEAN is 
			-- Parsed as:
			-- gboolean g_main_pending (
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean	g_main_pending		(void);
		external
			" C | <gtk/gtk.h>"
		end

	g_timeout_add_full (a_priority: INTEGER; a_interval: INTEGER; a_function: POINTER; a_data: POINTER; a_notify: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_timeout_add_full (
			--     gint a_priority,
			--     guint a_interval,
			--     GSourceFunc a_function,
			--     gpointer a_data,
			--     GDestroyNotify a_notify
			-- );
			--
			-- Original C code from glib.h:
			-- guint		g_timeout_add_full	(gint           priority,
			-- 					 guint          interval, 
			-- 					 GSourceFunc    function,
			-- 					 gpointer       data,
			-- 					 GDestroyNotify notify);
		external
			" C | <gtk/gtk.h>"
		end

	g_timeout_add (a_interval: INTEGER; a_function: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_timeout_add (
			--     guint a_interval,
			--     GSourceFunc a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- guint		g_timeout_add		(guint          interval,
			-- 					 GSourceFunc    function,
			-- 					 gpointer       data);
		external
			" C | <gtk/gtk.h>"
		end

	g_idle_add (a_function: POINTER; a_data: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_idle_add (
			--     GSourceFunc a_function,
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- guint		g_idle_add	   	(GSourceFunc	function,
			-- 					 gpointer	data);
		external
			" C | <gtk/gtk.h>"
		end

	g_idle_add_full (a_priority: INTEGER; a_function: POINTER; a_data: POINTER; a_destroy: POINTER): INTEGER is 
			-- Parsed as:
			-- guint g_idle_add_full (
			--     gint a_priority,
			--     GSourceFunc a_function,
			--     gpointer a_data,
			--     GDestroyNotify a_destroy
			-- );
			--
			-- Original C code from glib.h:
			-- guint	   	g_idle_add_full		(gint   	priority,
			-- 					 GSourceFunc	function,
			-- 					 gpointer	data,
			-- 					 GDestroyNotify destroy);
		external
			" C | <gtk/gtk.h>"
		end

	g_idle_remove_by_data (a_data: POINTER): BOOLEAN is 
			-- Parsed as:
			-- gboolean g_idle_remove_by_data (
			--     gpointer a_data
			-- );
			--
			-- Original C code from glib.h:
			-- gboolean	g_idle_remove_by_data	(gpointer	data);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_add_poll (a_fd: POINTER; a_priority: INTEGER) is 
			-- Parsed as:
			-- void g_main_add_poll (
			--     GPollFD *a_fd,
			--     gint a_priority
			-- );
			--
			-- Original C code from glib.h:
			-- void        g_main_add_poll          (GPollFD    *fd,
			-- 				      gint        priority);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_remove_poll (a_fd: POINTER) is 
			-- Parsed as:
			-- void g_main_remove_poll (
			--     GPollFD *a_fd
			-- );
			--
			-- Original C code from glib.h:
			-- void        g_main_remove_poll       (GPollFD    *fd);
		external
			" C | <gtk/gtk.h>"
		end

	g_main_set_poll_func (a_func: POINTER) is 
			-- Parsed as:
			-- void g_main_set_poll_func (
			--     GPollFunc a_func
			-- );
			--
			-- Original C code from glib.h:
			-- void        g_main_set_poll_func     (GPollFunc   func);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_unix_new (a_fd: INTEGER): POINTER is 
			-- Parsed as:
			-- GIOChannel* g_io_channel_unix_new (
			--     int a_fd
			-- );
			--
			-- Original C code from glib.h:
			-- GIOChannel* g_io_channel_unix_new    (int         fd);
		external
			" C | <gtk/gtk.h>"
		end

	g_io_channel_unix_get_fd (a_channel: POINTER): INTEGER is 
			-- Parsed as:
			-- gint g_io_channel_unix_get_fd (
			--     GIOChannel *a_channel
			-- );
			--
			-- Original C code from glib.h:
			-- gint        g_io_channel_unix_get_fd (GIOChannel *channel);
		external
			" C | <gtk/gtk.h>"
		end

	g_thread_init (a_vtable: POINTER) is 
			-- Parsed as:
			-- void g_thread_init (
			--     GThreadFunctions *a_vtable
			-- );
			--
			-- Original C code from glib.h:
			-- void	g_thread_init	(GThreadFunctions	*vtable);
		external
			" C | <gtk/gtk.h>"
		end

	g_static_mutex_get_mutex_impl (a_mutex: POINTER): POINTER is 
			-- Parsed as:
			-- GMutex* g_static_mutex_get_mutex_impl (
			--     GMutex **a_mutex
			-- );
			--
			-- Original C code from glib.h:
			-- GMutex*	g_static_mutex_get_mutex_impl	(GMutex	**mutex);
		external
			" C | <gtk/gtk.h>"
		end

	g_static_private_get (a_private_key: POINTER): POINTER is 
			-- Parsed as:
			-- gpointer g_static_private_get (
			--     GStaticPrivate *a_private_key
			-- );
			--
			-- Original C code from glib.h:
			-- gpointer g_static_private_get (GStaticPrivate	*private_key);
		external
			" C | <gtk/gtk.h>"
		end

	g_static_private_set (a_private_key: POINTER; a_data: POINTER; a_notify: POINTER) is 
			-- Parsed as:
			-- void g_static_private_set (
			--     GStaticPrivate *a_private_key,
			--     gpointer a_data,
			--     GDestroyNotify a_notify
			-- );
			--
			-- Original C code from glib.h:
			-- void     g_static_private_set (GStaticPrivate	*private_key, 
			-- 			       gpointer        	 data,
			-- 			       GDestroyNotify    notify);
		external
			" C | <gtk/gtk.h>"
		end

	glib_dummy_decl is 
			-- Parsed as:
			-- void glib_dummy_decl (
			-- );
			--
			-- Original C code from glib.h:
			-- extern void glib_dummy_decl (void);
		external
			" C | <gtk/gtk.h>"
		end

end -- class C_GLIB

--! This file was generated by the GOTE converter.
--! It is derived from the headers of GTK.
--! It is licenced under LGPL. (see www.gnu.org)