indexing
	description: "C struct definition"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class
	C_STRUCT

creation
	make

feature -- Initilization

	make (new_name: STRING; new_members: LINKED_LIST [C_ARGUMENT]; new_tag: STRING) is
		require
			new_members_not_void: new_members /= Void
		do
                        create scorer.make
                        scorer.set_expression ("s/\([a-z]\)\([A-Z]\)/\1_\2/g")

			name := clone (new_name)
			members := new_members
			tag := clone (new_tag)
		ensure
			name_set: name = new_name or name.is_equal (new_name)
			members_set: members = new_members
			tag_set: tag = new_tag or tag.is_equal (new_tag)
		end

feature -- Access

	typedef_name: STRING

	scored_typedef_name: STRING

	h_file_name: STRING

	set_h_file_name (n: STRING) is
		do
			h_file_name := clone (n)
		end

	set_typedef_name (a_typedef_name: STRING) is
		require
			typedef_name_not_void: a_typedef_name /= Void
		do
			typedef_name := clone (a_typedef_name)
			scored_typedef_name := scorer.run (a_typedef_name)
			scored_typedef_name.to_lower
		ensure
			typedef_name.is_equal (a_typedef_name)
		end

	name: STRING

	members: LINKED_LIST [C_ARGUMENT]
	
	tag: STRING

feature -- Conversion

	eiffel_text (include_directive: STRING): STRING is
			-- Eiffel text for accessing `Current' C struct.
		local
			r: FMT_STRING
			td: C_TYPEDEF
			arg: C_ARGUMENT
			eif_type: STRING
		do
			create r.make
			Result := r
			if scored_typedef_name /= Void then
				r.append ("indexing%N")
				r.append ("%Tdescription: %"" + typedef_name + " C struct access.%"%N")
				r.append ("%Tc_file: %"" + h_file_name + "%"%N")
				r.append ("%Tstatus: %"See notice at end of class%"%N%N")
				eif_type := "C_" + scored_typedef_name + "_STRUCT"
				eif_type.to_upper
				r.append ("class%N%T" + eif_type + "%N%Nfeature -- External C structs%N%N")
				from members.start
				until members.after
				loop
					arg := members.item
					td := arg.typedef
					if td.indir + arg.indir > 0 then
						eif_type := ("POINTER")
					elseif td.base.is_equal ("char") then
						eif_type := ("INTEGER")
					else
						eif_type := (td.base)
					end
					if arg.name /= Void and arg.type /= Void then
						r.append ("%T" + scored_typedef_name + "_struct_" + arg.name + " (a_c_struct: POINTER): " + eif_type + " is%N")
						r.append ("%T%Texternal%N%T%T%T")
						r.append ("%"C [struct " + include_directive + "] (" + typedef_name + "): EIF_" + eif_type + "%"%N")
						r.append ("%T%Talias%N%T%T%T%"" + arg.name + "%"%N%T%Tend%N%N")
					end
					members.forth
				end
				r.append ("end%N")
			end
		end

feature -- Output

        dump (dir: DIRECTORY; include_directive: STRING; status: STRING) is
                        -- Dump eiffel text to a file in `dir'
                local
                        f: RAW_FILE
                        n: STRING
                do
                                n := clone (scored_typedef_name)
                                n.prepend ("c_")
                                n.append ("_struct.e")
                                n.prepend_character (operating_environment.directory_separator)
                                n.prepend (dir.name)
                                create f.make (n)
                                f.open_write
                                f.put_string (eiffel_text (include_directive))
                                f.put_string (status)
                                f.close
                end

feature {NONE} -- Implementation

        scorer: STRING_EDITOR

invariant
	members_not_void: members /= Void

end -- class C_STRUCT

--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
