#include "gel.h"
#include <stdio.h>
#include <gtk/gtk.h>
#include "eif_eiffel.h"
#include "eif_argv.h"

void c_gtk_init (void)
{
	gtk_init(&eif_argc, &eif_argv);
}

static EIF_OBJECT eif_object_gtk_environment;
static EIF_PROC eif_feature_event_marshaler;

void c_event_marshaler_init (EIF_POINTER gtk_environment, EIF_PROC event_marshaler)
{
	eif_object_gtk_environment = henter (gtk_environment);
	eif_feature_event_marshaler = event_marshaler;
	gtk_signal_set_funcs ((GtkSignalMarshal) NULL, (GtkSignalDestroy) c_callback_id_destroy);
}

void c_event_marshaler (GtkWidget* widget, gpointer callback_id)
{
	eif_feature_event_marshaler (eif_access (eif_object_gtk_environment), (int) callback_id);
}

void c_signal_connect (GtkWidget* widget, const gchar* name, int callback_id)
{
	gtk_signal_connect (GTK_OBJECT (widget), name, GTK_SIGNAL_FUNC (c_event_marshaler), (gpointer) callback_id);
}

void c_callback_id_destroy (gpointer callback_id)
{
	printf ("void c_callback_id_destroy (%d)\n", (int) callback_id);
	eif_feature_event_marshaler (eif_access (eif_object_gtk_environment), - (int) callback_id);
}
