-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkArrow objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_ARROW_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

		
	type: STRING is "GTK_ARROW"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			arrow_type := widget_tree.get_string_from_field("arrow_type")
			shadow_type := widget_tree.get_string_from_field("shadow_type")
			xalign := widget_tree.get_real_string_from_field("xalign")
			yalign := widget_tree.get_real_string_from_field("yalign")
			xpad := widget_tree.get_integer_string_from_field("xpad")
			ypad := widget_tree.get_integer_string_from_field("ypad")
		end
			
	arrow_type: STRING
	shadow_type: STRING
	xalign: STRING
	yalign: STRING
	xpad: STRING
	ypad: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make("+arrow_type+", "+shadow_type+")")
			code.add_last(name + ".set_alignment("+ xalign +", "+ yalign +")")
			code.add_last(name + ".set_padding("+ xpad +", "+ ypad +")")
			add_widget_code(code)
		end

	parent_inherit: INHERIT_LIST is
		local
			temp_klass: KLASS
		do
			!!Result.make
			!!temp_klass.make_with_name("GTK_ARROWTYPE_ENUM")
			temp_klass.add_undefine_clause("is_equal, copy")
			Result.add(temp_klass)
			!!temp_klass.make_with_name("GTK_SHADOWTYPE_ENUM")
			temp_klass.add_undefine_clause("is_equal, copy")
			Result.add(temp_klass)
		end

end
