-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Contains routines for creating children for containers"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

deferred class CONTAINER

inherit

	WRITER

feature {NONE}

	last_class: CAN_BE_CREATED

	last_class_array: ARRAY[CAN_BE_CREATED]

	name: STRING is
		deferred
		end

	create_child_class_array(tree_array: ARRAY[TAG_TREE]) is
		local
			i: INTEGER
		do
			!!last_class_array.make(0,-1)
			if tree_array /= Void then
				from
					i := 0
				until
					i >= tree_array.count
				loop
					create_child_class(tree_array @ i)
					if last_class /= Void then
						last_class_array.add_last(last_class)
					end
					i := i + 1
				end
			end
		ensure
			array_exists: last_class_array /= Void
		end
		
	create_child_class(tree: TAG_TREE) is
		require
			non_void_tree: tree /= Void
		local
			info: CLASS_INFO
			class_writer: CLASS_WRITER
		do
			!!info.make(tree)
			last_class := Void
			if info.class_name.is_equal("Placeholder") then
				-- Might produce confusing error messages!!
				print("Warning: Placeholder in "+name+"%N")
			else
				print("Writing widget '"+info.name+"' of class '")
				print(info.class_name+"'%N")
				if info.class_name.is_equal("GtkDialog") then
					!GTK_DIALOG_WRITER!last_class.make(tree, info, src_dir)
				elseif info.class_name.is_equal("GtkWindow") then
					!GTK_WINDOW_WRITER!last_class.make(tree, info, src_dir)
				elseif info.class_name.is_equal("GtkAccelLabel") then
					!GTK_ACCEL_LABEL_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkAlignment") then
					!GTK_ALIGNMENT_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkArrow") then
					!GTK_ARROW_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkAspectFrame") then
					!GTK_ASPECT_FRAME_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkButton") then
					!GTK_BUTTON_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkCalendar") then
					!GTK_CALENDAR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkCheckButton") then
					!GTK_CHECK_BUTTON_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkCheckMenuItem") then
					!GTK_CHECK_MENU_ITEM_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkCList") then
					!GTK_CLIST_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkColorSelection") then
					!GTK_COLORSEL_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkColorSelectionDialog") then
					!GTK_COLOR_SELECTION_DIALOG_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkCombo") then
					!GTK_COMBO_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkCTree") then
					!GTK_CTREE_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkCurve") then
					!GTK_CURVE_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkDrawingArea") then
					!GTK_DRAWING_AREA_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkEntry") then
					!GTK_ENTRY_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkEventBox") then
					!GTK_EVENT_BOX_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkFileSelection") then
					!GTK_FILE_SELECTION_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkFixed") then
					!GTK_FIXED_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkFontSelection") then
					!GTK_FONTSEL_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkFontSelectionDialog") then
					!GTK_FONT_SELECTION_DIALOG_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkFrame") then
					!GTK_FRAME_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkGammaCurve") then
					!GTK_GAMMA_CURVE_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHandleBox") then
					!GTK_HANDLE_BOX_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHBox") then
					!GTK_HBOX_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHButtonBox") then
					!GTK_HBUTTON_BOX_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHPaned") then
					!GTK_HPANED_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHRuler") then
					!GTK_HRULER_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHScale") then
					!GTK_HSCALE_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHScrollbar") then
					!GTK_HSCROLLBAR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkHSeparator") then
					!GTK_HSEPARATOR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkInputDialog") then
					!GTK_INPUT_DIALOG_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkLabel") then
					!GTK_LABEL_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkLayout") then
					!GTK_LAYOUT_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkList") then
					!GTK_LIST_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkMenuBar") then
					!GTK_MENU_BAR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkMenuItem") then
					!GTK_MENU_ITEM_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkMenu") then
					!GTK_MENU_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkNotebook") then
					!GTK_NOTEBOOK_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkOptionMenu") then
					!GTK_OPTION_MENU_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkPacker") then
					!GTK_PACKER_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkPixmap") then
					!GTK_PIXMAP_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkPreview") then
					!GTK_PREVIEW_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkProgressBar") then
					!GTK_PROGRESS_BAR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkRadioButton") then
					!GTK_RADIO_BUTTON_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkRadioMenuItem") then
					!GTK_RADIO_MENU_ITEM_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkScrolledWindow") then
					!GTK_SCROLLED_WINDOW_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkSpinButton") then
					!GTK_SPIN_BUTTON_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkStatusbar") then
					!GTK_STATUS_BAR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkTable") then
					!GTK_TABLE_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkText") then
					!GTK_TEXT_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkToggleButton") then
					!GTK_TOGGLE_BUTTON_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkToolbar") then
					!GTK_TOOLBAR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkTree") then
					!GTK_TREE_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkVBox") then
					!GTK_VBOX_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkVButtonBox") then
					!GTK_VBUTTON_BOX_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkViewport") then
					!GTK_VIEWPORT_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkVPaned") then
					!GTK_VPANED_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkVRuler") then
					!GTK_VRULER_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkVScale") then
					!GTK_VSCALE_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkVScrollbar") then
					!GTK_VSCROLLBAR_WRITER!last_class.make(info.name, tree, src_dir)
				elseif info.class_name.is_equal("GtkVSeparator") then
					!GTK_VSEPARATOR_WRITER!last_class.make(info.name, tree, src_dir)
				end
				-- last_class = Void if there is no writer for the widget
				if last_class = Void then
					print("Class "+info.class_name+" is unrecognized. Ignoring.%N")
				else
					-- If the writer is a class_writer then write the class file
					class_writer ?= last_class
					if class_writer /= Void then
						class_writer.write_class
					end
				end
			end
		end

end -- CONTAINER
