/* (-*-c++-*-)
 * Authors:  Jens Peter Secher (jpsecher@diku.dk)
 *           Henning Makholm (makholm@diku.dk)
 * Content:  C-Mix system: 
 *
 * Copyright  1998. The TOPPS group at DIKU, U of Copenhagen.
 * Redistribution and modification are allowed under certain
 * terms; see the file COPYING.cmix for details.
 */

#ifndef __PARSER__
#define __PARSER__

#include <stdio.h>
#include "diagnostic.h"
#include "syntax.h"
#include "cpgm.h"

//--------------------------------------
// Flex-bison interface
//
// apart from what bison writes to the header file
//

extern LexerTracker ccchere;
int ccclex();

struct cccLexWrapper {
    bool ok ;
    FILE *f ;
    static int InUse ;
    static void Entry(Position&);
public:
    cccLexWrapper(const char *filename,const char* cppargs,Position ref);
    void parse();
    ~cccLexWrapper();
};

//----------------------------------
//
// The parser class itself

class cccParser {
 private:
    char const* fresh_anonymous_name();
    VarExpr* add_var_ref (char*,Position);
    void add_enum_decl(char const* name);
    void find_enum_decl(char const* name);
    void introduce_struct_decl(UserTag type,char const* name);
    void find_struct_decl(UserTag type,char const* name);
    void update_struct_decl(char const* name);
    void anonymous_struct_decl(UserTag type,char const* name);
    VarDecl* add_enumconst (char* n, Position pos, Expr* value);
    BaseType* make_basetype (Parse_Type* pt);
    Type* make_typedeftype(Parse_TypedefType* tt);
    Parse_Decl* make_decl (Parse_Type* pt);
    Parse_Decl* make_decl (Parse_UserType* ut);
    void lone_sue(Parse_UserType*);
    UserType* make_usertype (const Parse_UserType* const usert);
    void enter_scope (void);
    void leave_scope (void);
    void add_declaration (Parse_Decl *d);
    MemberDecl* add_member (Parse_Decl *d, Expr* bits = NULL);
    Parse_TypedefType* make_typedef (char const* name);
    Parse_Decl* make_decl (Parse_TypedefType* tt);
    void members_enter_scope (void);
    void members_leave_scope (void);
    FunDef* add_FunDef (Parse_Decl* board);
    FunDef* make_final_FunDef
        (Parse_Decl* board, Plist<VarDecl>* ds, Plist<UserDecl>* us);
    void old_style_decl_list (void);
    FunDef* old_style_add_FunDef (Parse_Decl* d);
    void add_Label (LabelStmt* stmt);
    Indirection* add_goto (char* label, const Position);
    void check_decl_match (ObjectDecl* ob, Parse_Decl* pd);
    void type_mismatch(char const*,Type*,Position,Type*,Position);
    void update_arg_old_fun_decl(Parse_Decl* d);
    void external_linker(ObjectDecl *ob,bool is_definition);
    void add_extern (Parse_Decl* d,bool tentative_defn);
    void add_static (Parse_Decl* d);
    void add_noclass (Parse_Decl* d);
    void add_initializer (Init* init);
    ObjectDecl* add_object (Parse_Decl* d, Linkage linkage);
    FunDef* common_add_Fun (FunDef* f);
    void clean_up_between_files();
 public:
    CProgram* get_program();
    int ParseNow(); // this is actually yyparse() from bison .. hack, hack..
};

extern cccParser parser ;

#endif
