/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

#include <stdio.h>
#include <stdlib.h>

#include "gs_token.h"
#include "gs_list.h"
#include "gs_parser.h"
#include "gs_translate.h"

#include "gs_getvar.h"

/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */
TOKEN *gs_get_variable(TOKEN *dictionary, char *string)
{
	TOKEN_HEAP
		*heap;


	if (! gs_isdictionary(dictionary))
	{
		return NULL;
	}

	heap = get_token_indirect_dictionary(NULL, dictionary);
	if (heap == NULL)
	{	return NULL;
	}

	return get_var(heap, string);
}


/* -------------------------------------------------------------------- */
/* Return Values:							*/
/*									*/
/*	The string value assigned to this identifier.			*/
/* 	NULL on error							*/
/*									*/
/* -------------------------------------------------------------------- */
char *gs_get_strvalue(TOKEN *token)
{
	if (! gs_isidentifier(token))
	{
		return NULL;
	}

	return token->ptr;
}


/* -------------------------------------------------------------------- */
/* Return Values:							*/
/*									*/
/*	The label/name of this 'Identfier', 'Dictionary' or 'List'	*/
/*	NULL on error							*/
/* -------------------------------------------------------------------- */
char *gs_get_labelvalue(TOKEN *token)
{
	return token->str;
}

