/*
 * tools/vgcfgbackup.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * June 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LVM; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    16/05/1998 - added lvmtab checking
 *
 */

#include <lvm_user.h>

char *cmd = NULL;

#ifdef DEBUG
int opt_d = 0;
#endif

int main ( int argc, char **argv)
{
   int c = 0;
   int opt_v = 0;
   int ret = 0;
   int v = 0;
#ifdef DEBUG
   char *options = "dh?v";
#else
   char *options = "h?v";
#endif
   char **vg_name_ptr = NULL;

   cmd = basename ( argv[0]);

   SUSER_CHECK;
   LVMTAB_CHECK;

   while ( ( c = getopt ( argc, argv, options)) != EOF) {
      switch ( c) {
#ifdef DEBUG
         case 'd':
            if ( opt_d > 0) {
               fprintf ( stderr, "%s -- d option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_d++;
            break;
#endif

         case 'h':
         case '?':
            printf ( "\n%s\n\n%s -- Volume Group Configuration Backup\n\n"
                     "Synopsis:\n"
                     "---------\n\n"
                     "%s\n"
#ifdef DEBUG
                     "\t[-d]\n"
#endif
                     "\t[-h/-?]\n"
                     "\t[-v]\n"
                     "\t[VolumeGroupName...]\n\n",
                     lvm_version, cmd, cmd);
            return 0;
            break;

         case 'v':
            if ( opt_v > 0) {
               fprintf ( stderr, "%s -- v option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_v++;
            break;

         default:
            fprintf ( stderr, "%s -- invalid command line option \"%c\"\n\n",
                      cmd, c);
            return LVM_EINVALID_CMD_LINE;
      }
   }
  
   CMD_MINUS_CHK;

   if ( optind < argc) {
      if ( opt_v > 0) printf ( "%s -- using volume group(s) on command line\n",
                               cmd);
      vg_name_ptr = argv + optind;
      argc = argc - optind;
   } else {
      if ( opt_v > 0) printf ( "%s -- finding all volume groups\n", cmd);
      vg_name_ptr = lvm_tab_vg_check_exist_all_vg ();
      argc = 0;
      if ( vg_name_ptr != NULL)
         for ( v = 0; vg_name_ptr[v] != NULL; v++) argc++;
      if ( argc > 0 && opt_v > 0) {
         printf ( "%s -- volume group%s found: ", cmd, argc > 1 ? "s" : "");
         for ( v = 0; vg_name_ptr[v] != NULL; v++)
            printf ( "%s ", vg_name_ptr[v]);
         printf ( "\n");
      }
   }

   argv = vg_name_ptr;
   optind = 0;

   if ( optind == argc) {
      printf ( "%s -- no volume groups found", cmd);
      return 0;
   }

   LVM_CHECK_IOP;
   LVM_LOCK ( 0);
   lvm_dont_interrupt ( 0);

   /* work on all given/found volume groups */
   for ( ; optind < argc; optind++)
      if ( ( ret = vg_cfgbackup ( argv[optind],
                                  VG_BACKUP_DIR, opt_v, NULL)) < 0) {
         fprintf ( stderr, "%s -- ERROR %d backing up volume group \"%s\"\n\n",
                   cmd, ret, argv[optind]);
         return LVM_EVGCFGBACKUP_VG_CFGBACKUP;
      }
      else {
         if ( ret == LVM_VG_CFGBACKUP_NO_DIFF) {
            printf ( "%s -- VGDA backup of volume group \"%s\" is "
                     "not necessary\n",
                     cmd, argv[optind]);
         } else {
            printf ( "%s -- successfull VGDA backup of volume group \"%s\"\n",
                     cmd, argv[optind]);
         }
      }

   printf ( "\n");

   lvm_interrupt ();
   LVM_UNLOCK ( 0);

   return 0;
}
