/*
 * tools/lib/vg_status_get_namelist.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March,November 1997
 * January 1999
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>


int vg_status_get_namelist ( char *vg_names) {
   int lvm = -1;
   int ret = 0;

#ifdef DEBUG
   debug ( "vg_status_get_namelist -- CALLED\n");
#endif

   if ( vg_names == NULL) return -LVM_EPARAM;

   if ( ( lvm = open ( LVM_DEV, O_RDONLY)) == -1)
      ret = -LVM_EVG_STATUS_GET_NAMELIST_OPEN;
   else {
      ret = ioctl ( lvm, VG_STATUS_GET_NAMELIST, vg_names);
      close ( lvm);
   }

#ifdef DEBUG
   debug ( "vg_status_get_namelist -- LEAVING\n");
#endif
   return ret;
}
