/*
 * tools/lib/pv_get_index.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * May 1997
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    10/16/97 - renamed to pv_get_index_by_kdev_t
 *             - implemented pv_get_index_by_name
 *
 */

#include <liblvm.h>

int pv_get_index_by_kdev_t ( vg_t *vg, kdev_t dev) {
   int p;
   int ret = -1;

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0) return -LVM_EPARAM;

#ifdef DEBUG
   debug ( "pv_get_index_by_kdev_t -- CALLED for VG \"%s\" and %02d:%02d\n",
           vg->vg_name, MAJOR ( dev), MINOR ( dev));
#endif

   for ( p = 0; p < vg->pv_max; p++) {
      if ( vg->pv[p] != NULL && vg->pv[p]->pv_dev == dev) {
         ret = p;
         break;
      }
   }

#ifdef DEBUG
   debug ( "pv_get_index_by_kdev_t -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}


int pv_get_index_by_name ( vg_t *vg, char *pv_name) {
   int p;
   int ret = -1;

#ifdef DEBUG
   debug ( "pv_get_index_by_name -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0 ||
        pv_name == NULL || pv_check_name ( pv_name) < 0) return -LVM_EPARAM;

   for ( p = 0; p < vg->pv_max; p++) {
      if ( vg->pv[p] != NULL && strcmp ( vg->pv[p]->pv_name, pv_name) == 0) {
         ret = p;
         break;
      }
   }

#ifdef DEBUG
   debug ( "pv_get_index_by_name -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
