#include <netconf.h>
#include <userconf.h>
#include "usermenu.h"
#include "usermenu.m"
#include "../../main/main.h"

void usermenu_show(const char *menuname)
{
	PRIVILEGE *menupriv = show_lookuppriv(menuname);
	if (!perm_access(menupriv
		,MSG_U(P_ENTERMENU,"enter this menu"))) return;
	const char *title = menuedit_gettitle (menuname);
	char key[100];
	sprintf (key,"%s.opt",menuname);
	SSTRINGS sels;
	int n = linuxconf_getall (K_USERMENU,key,sels,0);
	DIALOG dia;
	SSTRINGS keys,titles;
	linuxconf_gettree (keys,titles);
	for (int i=0; i<n; i++){
		const char *key = sels.getitem(i)->get();
		int pos = keys.lookup (key);
		if (pos != -1) dia.new_menuitem ("",titles.getitem(pos)->get());
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (title
			,""
			,help_nil
			,nof,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (nof >= 0 && nof < n){
			bool accesspriv = usermenu_getaccesspriv(menuname);
			PRIVILEGE *old = NULL;
			if (accesspriv) old = perm_setdefprivi (menupriv);
			dialog_jumpto (sels.getitem(nof)->get());
			linuxconf_mainmenu(true);
			dialog_jumpto (NULL);
			if (accesspriv) perm_setdefprivi (old);
		}
	}
}

static PRIVILEGES tbpriv;

static void show_setprivi()
{
	if (tbpriv.getnb()==0){
		SSTRINGS lst;
		int n = menuedit_getlist(lst);
		for (int i=0; i<n; i++){
			SSTRING *s = lst.getitem(i);
			const char *menu = s->get();
			char id[100];
			sprintf (id,"umenu_%s",menu);
			tbpriv.add (new PRIVILEGE (id,menuedit_gettitle (menu)
				,MSG_U(T_UMENUPRIV,"User defined menus")));
		}
	}
}

void show_resetpriv()
{
	tbpriv.remove_all();
}

PRIVILEGE *show_lookuppriv (const char *menu)
{
	show_setprivi();
	char id[100];
	sprintf (id,"umenu_%s",menu);
	return privilege_lookup (id);
}


static PRIVILEGE_DECLARATOR umenu_decl(show_setprivi);

