#pragma implementation
#include "mailconf.h"
#include "internal.h"
#include <netconf.h>
#include "mailconf.m"
#include <dialog.h>
#include <usercomng.h>

MAILCONF_HELP_FILE help_mailconf ("intro");
extern CONFIG_FILE f_sendmail;

PUBLIC void MAILCONF::spcs_edit()
{
	if (spcs.edit() == 0){
		spcs.build();
	}
}

void mailconf_edit()
{
	/* #Specification: mailconf / main menu
	*/
	int choice=0;
	int modified = 0;
	static const char *basic = MSG_U(M_BASIC,"basic information");
	static const char *spc_route = MSG_U(M_SPECIAL,"special (domain) routing");
	static const char *cplx_route = MSG_U(M_COMPLEX,"complex (user) routing");
	static const char *masq_rule = MSG_U(M_MASQ,"masquerading rules");
	static const char *mailfax = MSG_U(M_FAX,"mail to fax gateway");
	static const char *virt_domain = MSG_U(M_VIRTDOM,"virtual email domain");
	static const char *ualias = MSG_U(M_ALIASES,"user aliases");
	static const char *vualias = MSG_U(M_VALIASES,"virtual domain user aliases");
	static const char *spam_deny = MSG_U(M_SPAMDENY,"Rejected senders");
	static const char *spam_ip_allow = MSG_U(M_SPAMIPALLOW,"'Relay for' by IP");
	static const char *spam_name_allow = MSG_U(M_SPAMNAMEALLOW,"'Relay for' by name");
	static const char *spam_relay_allow = MSG_U(M_RELAYALLOW,"Relay to hosts");
	static const char *mailq = MSG_U(M_MAILQ,"the mail queue");

	static const char *test_cases = MSG_U(M_TESTS,"test cases");
	static const char *test_run = MSG_R(M_TESTS);
	static const char *menuopt1[]={
		"-",		MSG_U(T_BASECONF,"Basic"),
		MSG_U(M_CONFIG,"Configure"),	basic,
		"",			spc_route,
		"",			cplx_route,
		"",			masq_rule,
		"",			mailfax,
		"",			virt_domain,
		MSG_U(M_MANAGE,"Manage"),mailq,
		MSG_U(M_SETTING,"Setting"),	ualias,
		"",			vualias,
		NULL
	};
	static const char *menuopt2[]={
		"-",		MSG_U(T_SPAMRULES,"Anti-spam filters"),
		MSG_R(M_SETTING),	spam_deny,
		"",			spam_ip_allow,
		"",			spam_name_allow,
		"",			spam_relay_allow,
		//"Preparing",	test_cases,
		//"Run",		test_run,
		NULL
	};
	
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt1);
	dia.setmenu (MENU_MAILCONF);
	SSTRING sendpath (f_sendmail.getpath());
	dia.new_menuitem  (MSG_U(M_GENERATE,"Generate"),sendpath.get());
	dia.new_menuitems (menuopt2);
	while (1){
		MENU_STATUS code = dia.editmenu (
			MSG_U(T_SENDMAIL,"Sendmail configurator")
			,MSG_U(I_SENDMAIL
			 ,"This package allows you to configure\n"
			  "Sendmail, the mail delivery system\n")
			,help_mailconf
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			if (modified){
				char buf[100];
				sprintf (buf,MSG_U(Q_GENSENDMAIL,"Generating %s"),sendpath.get());
				char intro[1000];
				sprintf (intro
					,MSG_U(I_GENSENDMAIL
						,"You have modified sendmail's configuration.\n"
						 "A new %s must be generated.\n"
						 "Do you want to do it now")
					,sendpath.get());
				if (xconf_yesno(buf,intro,help_mailconf) == MENU_YES){
					MAILCONF mconf;
					mconf.generate(true);
				}
			}
			break;
		}else{
			const char *key = dia.getmenustr (choice);
			MAILCONF mconf;
			if (key == basic){
				modified |= mconf.basicedit();
			}else if (key == virt_domain){
				VDOMAINS vdomains;
				modified |= vdomains.edit();
			}else if (key == spc_route){
				mconf.spcs_edit();
			}else if (key == cplx_route){
				modified |= complex_edit();
			}else if (key == masq_rule){
				modified |= masq_edit();
			}else if (key == mailfax){
				modified |= mailfax_edit();
			}else if (key == mailq){
				mailq_edit();
			}else if (key == test_cases){
			}else if (key == test_run){
			}else if (key == ualias){
				aliases_edit();
			}else if (key == vualias){
				vdomain_editaliases();
			}else if (key == spam_deny){
				spam_edit_deny();
			}else if (key == spam_ip_allow){
				spam_edit_ip_allow();
			}else if (key == spam_name_allow){
				spam_edit_name_allow();
			}else if (key == spam_relay_allow){
				spam_edit_relay_allow();
			}else if (key == sendpath.get()){
				if (dialog_mode != DIALOG_TREE){
					mconf.generate(true);
					modified = 0;
				}
			}
		}
	}
}

/*
	Return the queue processing delay in minutes.
	Used to call sendmail (option -q)
*/
int mailconf_getqueuedelay()
{
	MAILCONF mconf;
	return mconf.getqueuedelay();
}


int mailconf_mainmenu()
{
	if (netconf_mainaccess()){
		while (1){
			mailconf_edit();
			if (netconf_checkupdate(true)!=2) break;
		}
	}
	return 0;
}

/*
	Generated sendmail.cf if needed
	Return 1 if the sendmail.cf was generated
*/
int mailconf_generate_if()
{
	int ret = 0;
	if (mailconf_generated_once()){
		mtable_makemap(f_mailtable);
		mtable_makemap(f_spam_deny);
		mtable_makemap(f_virtuser);
		mtable_makemap(f_pophash);
		MAILCONF mconf;
		ret = mconf.generate_if(true);
	}
	return ret;
}

// We declare this here to make sure aliascomng.o is linked in

static REGISTER_USERACCT_COMNG ppp (alias_newcomng);
static REGISTER_USERACCT_COMNG xxx (vdomain_newcomng);

