#pragma interface
#include <fviews.h>
#include "keyword.h"

class USERID: public ARRAY_OBJ {
public:
	SERVER *server;		// Belongs to server
	bool new_userid;
	SSTRING remote_user;	// Remote  user name
	SSTRING password;	// Specify remote account password
	SSTRING local_user;	// Local user name

				// Fetch:
				//   How:
	char fetchall;		// Fetch all messages whether seen or
				// not <"fetchall | no fetchall">.
	char keep;		// Don't delete  seen  messages  from
				// server <"keep | no keep">.
	char flush;		// Flush  all  seen  messages  before
				// querying <"flush | no flush">.
				//   Where:
	SSTRING folder;		// Specify remote folder to query
				//   Limits:
	int limit;		// Set message size limit.
	int warnings;		// Set message size warning interval.
	int batchlimit;		// Max  # messages to fetch in single
				// connect.
	int fetchlimit;		// Max # messages to forward in  sin-
				// gle connect.

				// Modify
	char stripcr;		// Strip carriage returns  from  ends
				// of lines <"stripcr | no stripcr">.
	char forcecr;		// Force  carriage returns at ends of
				// lines <"forcecr | no forcecr">.
	char pass8bits;		// Force BODY=8BITMIME to ESMTP  lis-
				// tener <"pass8bits | no pass8bits">.
	char mimedecode;	// Convert quoted-printable to  8-bit
				// in MIME messages (default)
				// <"mimecode | no mimecode">.
	char rewrite;		// Rewrite  destination addresses for
				// reply (default) <"no rewrite">.
	char dropstatus;	// Strip  Status and X-Mozilla-Status
				// lines out of incoming mail
				// <"dropstatus | no dropstatus">.

				// Delivery:
	SSTRING smtphost;	// Specify smtp host(s) to forward to
	SSTRING smtpaddress;	// Specify  the  domain  to be put in
				// RCPT TO lines.
	SSTRING mda;		// Specify MDA for local delivery

				// Not implemented:
	SSTRING bsmtp;		// Specify BSMTP batch file to append
				// to.
	SSTRING antispam;	// Specify  what  SMTP  returns   are
				// interpreted as spam-policy blocks
	int expunge;		// Perform  an  expunge  on every #th
				// message (IMAP only).
	SSTRING preconnect;	// be executed before each
				// connection.
	SSTRING postconnect;	// Command  to be executed after each
				// connection.
	SSTRING properties;	// String value is ignored by  fetch-
				// mail  (may  be  used  by extension
				// scripts).

	SSTRING old_remote_user;// Old remote  user name to find entry to
				// delete if removed in user co-manager
				// dialog
	/*~PROTOBEG~ USERID */
public:
	USERID(const char *_userid_name);
	USERID( void );
	int edit (void);
	bool input_error (void);
	int write ( int button );
	int write_userid( FILE *fout );
	void print_line( char *word, FILE *fout );
	void write_item( FILE *fout, VIEWITEM *item );
private:
	void init (void);
public:
	/*~PROTOEND~ USERID */
};

class USERIDLIST: public ARRAY {
private:
	/*~PROTOBEG~ USERIDLIST */
public:
	USERIDLIST( );
	int edit( SERVER *server );
	USERID *getitem (const char *id) const;
	USERID *getitem (int negative) const;
	void read (SERVER *server);
	void read_users( KEYWORDLIST *keywordlist, KEYWORD *keyword, char *word, SERVER *server );
	/*~PROTOEND~ USERIDLIST */
};

