#include "internal.h"
#include "apache.m"

static APACHE_HELP_FILE help_dir ("dir");
static APACHE_HELP_FILE help_file ("file");

static HTTPD_CONFIG *httpd;

PUBLIC void HTTPD_OVERRIDE::setallopt(int val)
{
	char cval = (val != 0) ? 1 : 0;
	authconfig = cval;
	fileinfo = cval;
	indexes = cval;
	limit = cval;
	options = cval;
}

PUBLIC HTTPD_OVERRIDE::HTTPD_OVERRIDE()
{
	setallopt (1);
}

PUBLIC void HTTPD_OVERRIDE::setdia (DIALOG &dia)
{
	dia.newf_title ("",MSG_U(T_OVERRIDE,"Override policies"));
	dia.newf_chk ("",authconfig,MSG_U(I_AUTHCONFIG,"Authentification configs"));
	dia.newf_chk ("",fileinfo,MSG_U(I_FILEINFO,"File info"));
	dia.newf_chk ("",indexes,MSG_R(I_INDEXES));
	dia.newf_chk ("",limit,MSG_U(I_LIMIT,"Limits"));
	dia.newf_chk ("",options,MSG_U(I_OPTIONS,"Options"));
}

PUBLIC int HTTPD_DIRS::f_edit(HTTPD_CONFIG &_httpd)
{
	httpd = &_httpd;
	int ret = -1, nof = 0;

	while (1){
		int n = getnb();

		HTTPD_DIRS tmp;
		tmp.neverdelete();
		for (int i=0; i<n; i++){
			HTTPD_DIR *d = getitem(i);
			if(d->dmode == d_FILE || d->dmode == d_FILEMATCH) {
				tmp.add(d);
			}
		}

		n = httpd->defdom.unks.getnb();

		for (int i=0; i<n; i++){
			HTTPD_UNKNOWN *unk = httpd->defdom.unks.getitem(i);
			int m = unk->dirs.getnb();
			for(int j=0;j<m;j++) {
				HTTPD_DIR *d = unk->dirs.getitem(j);
				if(d->dmode == d_FILE || d->dmode == d_FILEMATCH) {
					tmp.add (d);
				}
			}
		}

		DIALOG_RECORDS dia;
		dia.newf_head ("",MSG_U(T_FILES,"Files"));
		for(int i=0;i<tmp.getnb();i++){
			dia.new_menuitem("",tmp.getitem(i)->path.get());
		}

		dia.addwhat (MSG_U(I_NEWFILE
			,"Select [Add] to add a new file(s) rule(s)"));

		MENU_STATUS code = dia.editmenu (MSG_R(T_FILES)
			,MSG_U(I_FILES,"You can override various rules files\n"
				"per files")
			,help_file
			,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_ADD){
			HTTPD_DIR *d = new HTTPD_DIR;
			d->dmode = d_FILE;
			ret = editone (d);
		}else if (nof < tmp.getnb() && nof >= 0){
			ret = tmp.getitem(nof)->edit();
		}
	}
	if(ret == 0) httpd->write();
	return ret;
}

PUBLIC int HTTPD_DIR::edit()
{
	int ret = -1;
	DIALOG dia;
	FIELD_COMBO *combo;

	dia.setbutinfo (MENU_USR1,MSG_U(B_USERSCONF,"Users Configuration"),"");
	dia.newf_str (MSG_U(F_PATH,"Directory path"),path);

	feats.setdia (dia);
	over.setdia (dia);

	dia.newf_title ("",MSG_U(T_DIRSSL,"SSL Options"));
	dia.newf_str (MSG_R(F_SSLCIPHERSUITE),SSLCipherSuite);
	dia.newf_str (MSG_U(F_SSLREQUIRE,"Require"),SSLRequire);
	dia.newf_str (MSG_R(F_SSLOPTIONS),SSLOptions);
	dia.newf_num (MSG_U(F_SSLVERIFYDEPTH,"Verify Depth"),SSLVerifyDepth);
    dia.newf_chk ("",SSLRequireSSL,MSG_U(I_SSLREQUIRESSL,"SSL require SSL"));


    combo = dia.newf_combo (MSG_R(F_SSLVERIFYCLIENT),SSLVerifyClient);

	verifyclientcomb(*combo);


	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_DIRRULES,"Directory rules")
			,MSG_U(I_DIRRULES,"You are allowed to enter configurations\n"
				"which apply to this directory and its sub-directories\n")
			,help_dir
			,nof,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL|MENUBUT_USR1);
		if (code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				ret = 1;
				break;
			}
		}else if (code == MENU_USR1) {
			auths.edit();
		}else{
			ret = 0;
			break;
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

PUBLIC HTTPD_DIR *HTTPD_DIRS::getitem(int no) const
{
	return (HTTPD_DIR*)ARRAY::getitem(no);
}


PUBLIC int HTTPD_DIRS::write()
{
	return httpd->write();
}

PUBLIC int HTTPD_DIR::f_edit()
{
	int ret = -1;
	DIALOG dia;
	dia.newf_str (MSG_U(F_FPATH,"File(s) path"),path);
	feats.setdia (dia);
	over.setdia (dia);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_FILERULES,"Files rules")
			,MSG_U(I_FILERULES,"You are allowed to enter configurations\n"
				"which apply to this file(s)\n")
			,help_file
			,nof,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
		if (code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				ret = 1;
				break;
			}
		}else{
			ret = 0;
			break;
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

PUBLIC int HTTPD_DIRS::edit(HTTPD_CONFIG &_httpd)
{
	httpd = &_httpd;
	int ret = -1, nof = 0;
	while (1){
		DIALOG dia;
		HTTPD_DIRS tmp;
		tmp.neverdelete();
		int n = getnb();
		for (int i=0; i<n; i++){
			HTTPD_DIR *d = getitem(i);
			if(d->dmode == d_DIR || d->dmode == d_DIRMATCH) {
				tmp.add (d);
			}
		}

		n = httpd->defdom.unks.getnb();

		for (int i=0; i<n; i++){
			HTTPD_UNKNOWN *unk = httpd->defdom.unks.getitem(i);
			int m = unk->dirs.getnb();
			for(int j=0;j<m;j++) {
				HTTPD_DIR *d = unk->dirs.getitem(j);
				if(d->dmode == d_DIR || d->dmode == d_DIRMATCH) {
					tmp.add (d);
				}
			}
		}

		for(int i=0;i<tmp.getnb();i++){
			dia.new_menuitem("",tmp.getitem(i)->path.get());
		}

		dia.addwhat (MSG_U(I_NEWDIR,"Select [Add] to add a new directory rule"));
		MENU_STATUS code = dia.editmenu (MSG_U(T_DIRS,"Directories")
			,MSG_U(I_DIRS,"You can override various rules directory\n"
				"per directory")
			,help_dir
			,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_ADD){
			HTTPD_DIR *d = new HTTPD_DIR;
			d->dmode = d_DIR;
			ret = editone (d);
		}else if (nof < tmp.getnb() && nof >= 0){
			HTTPD_DIR *d = tmp.getitem(nof);	
			ret = d->edit();
			if (ret == 0){
				_httpd.write();
			}else if (ret == 1){
				remove_del (d);
				_httpd.write ();
			}
		}
	}
	if(ret == 0) httpd->write();
	return ret;
}

