#!/bin/sh
# rmlang.sh
# aurelio@conectiva.com.br
# Fri Oct 16 10:47:28 EDT 1998
# just a little thing to remove a lang...

LANG=$1
MSGDIR=messages
HLPDIR=help.files
DIRBIN=/usr/lib/linuxconf

# just show the error msg on the screen
Error() { echo -e "\n$1\n"; exit }

# beginning of the barricade
[ ! $1 ] && Error "usage: rmlang.sh id-of-the-lang" 

[ "`pwd | rev | cut -c1-8 | rev`" = "$MSGDIR" ] || \
# `basename `pwd`` doesn't works...
Error "this script must be runned on the messages directory"

[ -d $LANG ] || Error "the lang \"$LANG\" doesn't exist"
# end of the barricade

# sanity confirmation...
echo "you'll delete ALL the messages and help files for the \"$LANG\" language."
echo -n "it's a one way path. are you sure? [Yn]"
read; [ "$REPLY" = n ] && { echo -e "\nnothing was excluded.\n" ; exit }

# removing the msgs dir
rm -rf $LANG
# removing the helps dir
rm -rf ../$HLPDIR/$LANG
# removing the compiled msgs/helps
rm -rf $DIRBIN/help.$LANG
# removing the entry of the lang
rm -f  $DIRBIN/lang_intro.$LANG

Error "the language "$LANG" was eradicated."


