#include <misc.h>
#include <dialog.h>
#include <translat.h>

// #Specbeg: dialog / sample code / records

class PERSON: public ARRAY_OBJ{
public:
	SSTRING name;
	SSTRING surname;
	SSTRING tel;
	PERSON(const char *_name, const char *_surname, const char *_tel){
		name.setfrom (_name);
		surname.setfrom (_surname);
		tel.setfrom (_tel);
	}
};

class PERSONS: public ARRAY{
public:
	PERSON *getitem(int no) const{
		return (PERSON*)ARRAY::getitem(no);
	}
};


static void sample_records()
{
	// Fill few records
	PERSONS tb;
	tb.add (new PERSON("Gelinas","Jacques","111-2222"));
	tb.add (new PERSON("Who","John","222-2222"));
	tb.add (new PERSON("Red","Jessy","333-2222"));
	//
	DIALOG_RECORDS dia;
	dia.newf_head ("","Name\tSurname\tTelephone");
	int nof = 0;
	while (1){
		for (int i=0; i<tb.getnb(); i++){
			PERSON *p = tb.getitem(i);
			char buf[100];
			snprintf (buf,sizeof(buf)-1,"%s\t%s",p->surname.get(),p->tel.get());
			dia.set_menuitem (i,p->name.get(),buf);
		}
		// Remove extra fields
		// dia.getnb() includes the header
		dia.remove_last (tb.getnb()+1);
		MENU_STATUS code = dia.editmenu ("title","introduction",help_nil
			,nof,MENUBUT_ADD|MENUBUT_DEL);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_DEL){
			tb.remove_del (0);
		}else if (code == MENU_ADD){
			static int add=1;	// Add arbitrary fields
			char buf[10];
			sprintf (buf,"%d",add++);
			tb.add (new PERSON(buf,buf,buf));
		}else{
			xconf_notice ("Edit field %d",nof);
		}
	}
}

// #Specend:
	

int main (int argc, char *argv[])
{
	argc = dialog_parseuioptions (argc, argv);
	linuxconf_loadmsg ("linuxconf",PACKAGE_REV);
	translat_checkmissing();
	sample_records();
	return 0;
}

