#pragma implementation
#include "diadef.h"
#include "dialog.h"
#include "internal.h"
#include "../diajava/diajava.h"

void dialog_required()
{
	// Make sure those object file are linked as they are needed
	// by modules
	pass_required();
	sheet_required();
}

/*
	Update all variables with the edition buffer.
*/
PUBLIC void DIALOG::save()
{
	for (int i=0; i<getnb(); i++){
		FIELD *fi = getitem(i);
		if (!fi->is_readonly()) fi->save();
	}
	rstmodified();
}
/*
	Set all variables to its original content.
*/
PUBLIC void DIALOG::restore()
{
	for (int i=0; i<getnb(); i++){
		FIELD *fi = getitem(i);
		if (!fi->is_readonly()) fi->restore();
	}
}
/*
	Reload some input buffer from the variables.
*/
PUBLIC void DIALOG::reload(int start, int end)
{
	char tmp[200];
	const char *dianame = setguiname(tmp);
	for (int i=start; i<end && i<getnb(); i++){
		FIELD *fi = getitem(i);
		if (!fi->is_readonly()) fi->reload(dianame,i);
	}
	if (dianame == NULL) internal->guidone = false;
}
/*
	Reload all the input buffer from the variables.
*/
PUBLIC void DIALOG::reload()
{
	reload (0,getnb());
}
/*
	Reload the input buffer from the variable.
*/
PUBLIC void DIALOG::reload(int no)
{
	reload (no,no+1);
}
/*
	Set all field into readonly mode
*/
PUBLIC void DIALOG::set_readonly()
{
	for (int i=0; i<getnb(); i++) getitem(i)->set_readonly();
}
/*
	Set the last field entered readonly
*/
PUBLIC void DIALOG::set_lastreadonly()
{
	int n = getnb()-1;
	if (n >= 0) getitem(n)->set_readonly();
}
/*
	Set the last field entered so it does not accept empty input
*/
PUBLIC void DIALOG::last_noempty()
{
	int n = getnb()-1;
	if (n >= 0) getitem(n)->set_noempty();
}
/*
	Return != 0 if anyone field has been modified
*/
PUBLIC int DIALOG::was_modified()
{
	modified = 0;
	return ARRAY::was_modified();
}

PUBLIC FIELD *DIALOG::getitem(int no)
{
	return (FIELD*)ARRAY::getitem(no);
}

EXPORT void dialog_clear()
{
	if (dialog_mode != DIALOG_HTML
			&& dialog_mode != DIALOG_TREE
			&& dialog_mode != DIALOG_TREEJMP){
		static char done = 0;
		if (!done){
			done = 1;
			if (diagui_init()!=-1){
				dialog_setmode (DIALOG_GUI);
			}else{
				init_dialog();
				attr_clear(stdscr, LINES, COLS, screen_attr);
			}
		}
	}
}


void dialog_clearinit()
{
	static char done = 0;
	if (!done){
		dialog_clear();
		done = 1;
	}
}

PUBLIC FIELD_MSG::FIELD_MSG()
{
	is_loaded = 0;
}


/*
	Record the icon name (no extension) which describe this dialog.
	This will often be a translatable name (uh ?) allowing different icons
	for different culture/language/society
*/
PUBLIC void DIALOG::seticon (const char *_icon)
{
	internal->icon.setfrom (_icon);
}

PUBLIC void DIALOG::setbutinfo (
	int id,					// MENU_xxxx (Not MENUBUT_xxxx)
	const char *title,		// Name that goes in the button
	const char *icon)		// Icon to use in html mode
{
	internal->buttons->setbutinfo(id,title,icon);
}

/*
	Use this function to record preformat HTML information.
	This function may be called several times and will override the
	normal formatting of dialog. This is a bypass for dialog which are
	HTML aware and want to do something "nicer".

	Using this function once will disable all other field formatting.
*/
PUBLIC void DIALOG::html_body(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[10000];
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	internal->html_bypass.body.append (buf);
	va_end (list);
}

/*
	Use this function to record preformat HTML introduction which
	will be insert at the beginning of the dialog.
*/
PUBLIC void DIALOG::html_intro(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[10000];
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	internal->html_bypass.intro.append (buf);
	va_end (list);
}
/*
	Use this function to record preformat HTML top (including <body) which
	will override most of the top of the html dialog
*/
PUBLIC void DIALOG::html_top(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[10000];
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	internal->html_bypass.top.append (buf);
	va_end (list);
}

/*
	Use this function to record preformat HTML end of document which
	will be append after the body of the dialog.
*/
PUBLIC void DIALOG::html_end(const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[10000];
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	internal->html_bypass.end.append (buf);
	va_end (list);
}

/*
	Record a title string which will be displayed inside the dialog
	centered.

	The other title goes on the window.

	In HTML mode, the standard title in drawn centered unless overriden
	by this one. This is because the title is not readable by many
	browser (The top border of the window contain to much).
*/
PUBLIC void DIALOG::set_alt_title(const char *_title)
{
	internal->internal_title.setfrom (_title);
}

PUBLIC void DIALOG::setsidetitle (const char *ctl, ...)
{
	va_list list;
	va_start (list,ctl);
	char buf[200];
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	va_end (list);
	internal->sidetitle.setfrom (buf);
}

/*
	Make sure the dialog is as tall as possible in text mode.
	This is mainly use by the treemenu dialog, to avoid visual effect
	each time one expand a branch.
*/
PUBLIC void DIALOG::setheight_hint()
{
	internal->height_hint = true;
}

/*
	Print a message at the bottom of the screen
*/
EXPORT void dialog_consout (const char *ctl, ...)
{
	char buf[2000];
	va_list list;
	va_start (list,ctl);
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	va_end (list);
	if (dialog_mode == DIALOG_CURSES){
		if (!dialog_isinit()){
			fputs (buf,stdout);
		}else if (isatty(0)){
			dialog_clearinit();
			if (dialog_mode == DIALOG_CURSES){
				wattrset(stdscr, screen_attr);
				char *pt = buf;
				while (*pt != '\0'){
					char *start = pt;
					pt = strchr(pt,'\n');
					bool do_scroll = false;
					if (pt != NULL){
						*pt++ = '\0';
						do_scroll = true;
					}
					wmove(stdscr, LINES-1,0);
					waddstr (stdscr,start);	
					if (do_scroll){
						scrollok (stdscr,1);
						wscrl (stdscr,1);
						wmove(stdscr, LINES-1,0);
					}else{
						break;
					}
				}
				wrefresh(stdscr);
			}
		}
	}else if (dialog_mode == DIALOG_GUI){
		// One day, we will print message to a log window
		// the user can open/close any time during a linuxconf session
	}
}

/*
	Add a secondary help to the dialog.
*/
PUBLIC void DIALOG::addhelp(HELP_FILE &help, const char *title)
{
	internal->buttons->addhelp(help,title);
}

/*
	Record a message that must wake up this dialog.
	The message is sent using dialog_sendmessage().
*/
PUBLIC void DIALOG::waitfor (const char *msg)
{
	internal->waitmsg.add (new SSTRING(msg));
}

/*
	Register the dialog type
*/
PUBLIC void DIALOG::settype (DIALOG_TYPE type)
{
	internal->diatype = type;
}

