
#include <std.h>
#include "colors.h"

unsigned PairCount = 1;

PairList *Pairs[MAX_PAIRS];

int Pair(short fg, short bg)
{
	for (register unsigned i = 1; i < PairCount; i++)
		if (Pairs[i]->fore_color == fg && Pairs[i]->back_color == bg)
			return COLOR_PAIR(Pairs[i]->Pair);

	Pairs[PairCount] = (PairList *) malloc(sizeof(PairList));
	Pairs[PairCount]->Pair = PairCount;

	init_pair(Pairs[PairCount]->Pair, fg, bg);

	Pairs[PairCount]->fore_color = fg;
	Pairs[PairCount]->back_color = bg;

	return COLOR_PAIR(Pairs[PairCount++]->Pair);
}

void free_pairs(void)
{
	for (register unsigned i = 0; i < PairCount; i++)
		free(Pairs[i]);

	PairCount = 0;
}
