#! /bin/bash
#
# create a prototype for silo boot floppy image for dbootstrap
# (C) Eric Delaunay <delaunay@debian.org>, 1998

. ./common.sh

if [ $# != 4 ]; then
	echo "Usage: $0 archive-path image-name subarch blocks" >&2
	exit 1
fi

if [ ! $arch = sparc ]; then
	error "Unsupported architecture: $arch."
fi

archive=$1
image=$2
subarch=$3
blocks=$4

loopdev=loop3
device=/dev/$loopdev

mountpoint=${tmpdir}/boot-floppies/mnt.siloproto
tmp=${tmpdir}/boot-floppies/silo_proto.$$

# clean up old run aborted
$ROOTCMD umount $mountpoint &>/dev/null || umount $device &>/dev/null || true

info "making loop filesystem in '$image', size ${blocks}k"
# set the size of the floppy image
dd if=/dev/zero of=$image bs=1k count=$blocks

if [ ! -d $mountpoint ]; then
	make_tmpdir $mountpoint
fi
make_tmpdir $tmp

# define floppy type
case $blocks in
1440)
	sectors=18 ;;
720)
	sectors=9 ;;
*)
	echo "unsupported floppy size ($blocks kB)" >&2
	exit 1
esac
# create the filesystem
# (get more space: -i 32768 on 1.44MB image gives only 48 inodes)
info "formatting the new image (device $device)"
mke2fs -F -q -i 32768 -m 0 $image $blocks

# create a valid first sector (required by Sun to boot from floppy)
# only one whole disk partition (#3)
# (need to be done after mke2fs otherwise the partition table is
#  killed by mke2fs.  It's a bug in mke2fs for sparc !!!)
info "partitioning the new image"
fdisk $image > /dev/null << EOF || true
0
2
$sectors
80
0




d
1
d
2
p
w
EOF
# and mount the floppy image
info "mounting new disk image at $mountpoint"
$ROOTCMD mount $image $mountpoint -o loop=$device
# get even more space (12KB)
$ROOTCMD rmdir $mountpoint/lost+found
# -> 1428KB free on the floppy image

# fill it
$ROOTCMD mkdir $mountpoint/boot
silopkg=`make_paths silo`
debug "extracting $silopkg"
dpkg --extract $silopkg $tmp
if [ x$subarch = xsun4u ]; then
	info "installing UltraSPARC bootloader"
	silo_data="$tmp/boot/ultra.b $tmp/boot/second.b"
	silo_opt=-u
else
	info "installing SPARC bootloader"
	silo_data="$tmp/boot/first.b $tmp/boot/second.b"
	silo_opt=-U
fi
silo_data="$silo_data $tmp/boot/fd.b"
$ROOTCMD cp -p $silo_data $mountpoint/boot
info "writing /etc/silo.conf"
$ROOTCMD mkdir $mountpoint/etc
$ROOTCMD sh -c '(cat > '$mountpoint'/etc/silo.conf << EOF
partition=3
root=/dev/fd0
timeout=100
image=/linux
label=linux
append="load_ramdisk=1 prompt_ramdisk=1"
read-write

# to be used with concatenated rescue disk & root.bin on one 2.88MB floppy"
image=/linux
label=big
append="load_ramdisk=1 ramdisk_start=1440 prompt_ramdisk=0"
read-write
EOF
)'

# run silo to register first & second stage loaders
info "running silo to make the image bootable"
$ROOTCMD $tmp/sbin/silo $silo_opt -r $mountpoint

# then cleanup
info "unmounting, cleaning up"
$ROOTCMD rm -f $mountpoint/boot/old.b
rm -fr $tmp &
$ROOTCMD umount $mountpoint
rmdir $mountpoint
info "compressing the image"
gzip -9f $image
info "silo image complete: " `ls -l $image.gz`

exit 0
