#! /bin/sh
# skeleton	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian GNU/Linux
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.6  11-Nov-1996  miquels@cistron.nl
#

PATH=/usr/local/sbin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/apcd
NAME=apcd
DESC="APC Smart UPS Daemon"

test -f $DAEMON || exit 0
test -f /etc/apcd.conf || exit 0
if grep '^#!Unconfigured!' /etc/apcd.conf >/dev/null; then
   echo "$NAME: unconfigured"
   exit 0
fi

set -e

case "$1" in
  start)
    echo -n "Starting $DESC: $NAME"
    start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid --exec $DAEMON
    echo "."
    ;;
  stop)
    echo -n "Stopping $DESC: $NAME"
    start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid --exec $DAEMON
    echo "."
    ;;
  reload|force-reload)
    echo "Reopening $NAME logfiles"
    start-stop-daemon --stop --signal 1 --quiet --pidfile /var/run/$NAME.pid --exec $DAEMON
    ;;
  restart)
    echo -n "Restarting $DESC: $NAME"
    start-stop-daemon --stop --quiet --pidfile /var/run/$NAME.pid --exec $DAEMON
    start-stop-daemon --start --quiet --pidfile /var/run/$NAME.pid --exec $DAEMON
    echo "."
    ;;
  poweroff)
    # poweroff not supported by apcd
    ;;
  *)
    echo "Usage: /etc/init.d/$NAME {start|stop|reload|force-reload|restart|poweroff}"
    exit 0
    ;;
esac

exit 0
