/* Copyright (C) 1991, 1992, 1996, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifdef DEBUG
#include <stdio.h>
#endif
#include <stdlib.h>
#include <wchar.h>

char    *prembstowcs_s      = NULL;
wchar_t *prembstowcs_w      = NULL;
char    *mbstowcs_savestr   = NULL;
int      mbstowcs_savestate = 0;

extern mbstate_t __no_r_state;	/* Defined in mbtowc.c.  */

/* Convert the string of multibyte characters in S to `wchar_t's in
   PWCS, writing no more than N.  Return the number written,
   or (size_t) -1 if an invalid multibyte character is encountered.

   Attention: this function should NEVER be intentionally used.
   The interface is completely stupid.  The state is shared between
   all conversion functions.  You should use instead the restartable
   version `mbsrtowcs'.  */
size_t
mbstowcs (wchar_t *pwcs, const char *s, size_t n)
{
  mbstate_t save_shift = __no_r_state;
  size_t written;

#ifdef DEBUG
  fprintf(stderr, "begin: mbstowcs\n");
  fprintf(stderr, "info: wchar pwcs = [%p]\n", pwcs);
  fprintf(stderr, "info: char  s    = [%s]\n", s ? s : "(null)");
  fprintf(stderr, "info: char  s(p) = [%p]\n", s);
  fprintf(stderr, "info: size  n    = [%d]\n", n);
#endif

  if(2 == mbstowcs_savestate) {
    s = mbstowcs_savestr;
#ifdef DEBUG
    fprintf(stderr, "info: *** restore s !!! ***\n");
    fprintf(stderr, "info: char  s    = [%s](restored)\n", s ? s : "(null)");
#endif
  } else {
    if ( NULL != mbstowcs_savestr ) {
      free(mbstowcs_savestr);
    }
    mbstowcs_savestr = strdup(s);
  }
  mbstowcs_savestate = 0;

#ifdef HAVE_MBSRTOWCS_BUG
  if (NULL == pwcs && 0 == n) { /* katamaru temae */
#ifdef DEBUG
    fprintf(stderr, "info: *** I don't call mbsrtowcs. ***\n", n);
#endif
    written = strlen(s);

    prembstowcs_w = NULL;
    prembstowcs_s = s;
  } else {
#endif
    written = mbsrtowcs (pwcs, &s, n, &__no_r_state);

    prembstowcs_w = pwcs;
    prembstowcs_s = s;
#ifdef HAVE_MBSRTOWCS_BUG
  }
#endif

  /* Restore the old shift state.  */
  __no_r_state = save_shift;

  /* Return how many we wrote (or maybe an error).  */
#ifdef DEBUG
  fprintf(stderr, "info: return %d(mbstowcs)\n", written);
#endif
  return written;
}
